/* chess-engine-uci.c generated by valac 0.11.6, the Vala compiler
 * generated from chess-engine-uci.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessEngineUCIPrivate ChessEngineUCIPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
	gchar* binary;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEngineUCI {
	ChessEngine parent_instance;
	ChessEngineUCIPrivate * priv;
};

struct _ChessEngineUCIClass {
	ChessEngineClass parent_class;
};

struct _ChessEngineUCIPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* moves;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	gboolean waiting_for_move;
};


static gpointer chess_engine_uci_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_UCI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIPrivate))
enum  {
	CHESS_ENGINE_UCI_DUMMY_PROPERTY
};
ChessEngineUCI* chess_engine_uci_new (gchar** options, int options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, gchar** options, int options_length1);
ChessEngine* chess_engine_new (void);
ChessEngine* chess_engine_construct (GType object_type);
static gchar** _vala_array_dup7 (gchar** self, int length);
static void chess_engine_uci_start_cb (ChessEngineUCI* self);
static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
static void chess_engine_uci_real_start_game (ChessEngine* base);
static void chess_engine_uci_real_request_move (ChessEngine* base);
static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move);
gchar* chess_move_get_engine (ChessMove* self);
static void chess_engine_uci_real_undo (ChessEngine* base);
static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1);
static void chess_engine_uci_configure (ChessEngineUCI* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static gchar* _vala_array_dup8 (gchar* self, int length);
static void chess_engine_uci_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self) {
	chess_engine_uci_start_cb (self);
}


ChessEngineUCI* chess_engine_uci_construct (GType object_type, gchar** options, int options_length1) {
	ChessEngineUCI * self = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self = (ChessEngineUCI*) chess_engine_construct (object_type);
	_tmp0_ = (_tmp1_ = options, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup7 (_tmp1_, options_length1));
	_tmp2_ = _tmp0_;
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->options_length1 = options_length1;
	self->priv->_options_size_ = self->priv->options_length1;
	self->priv->options = _tmp2_;
	_tmp3_ = g_new0 (gchar, 0);
	_tmp4_ = _tmp3_;
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer_length1 = 0;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	self->priv->buffer = _tmp4_;
	_tmp5_ = g_strdup ("");
	_tmp6_ = _tmp5_;
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp6_;
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_uci_start_cb_chess_engine_starting, self, 0);
	return self;
}


ChessEngineUCI* chess_engine_uci_new (gchar** options, int options_length1) {
	return chess_engine_uci_construct (TYPE_CHESS_ENGINE_UCI, options, options_length1);
}


static void chess_engine_uci_start_cb (ChessEngineUCI* self) {
	g_return_if_fail (self != NULL);
	chess_engine_write_line ((ChessEngine*) self, "uci");
}


static void chess_engine_uci_real_start_game (ChessEngine* base) {
	ChessEngineUCI * self;
	self = (ChessEngineUCI*) base;
	chess_engine_write_line ((ChessEngine*) self, "ucinewgame");
}


static void chess_engine_uci_real_request_move (ChessEngine* base) {
	ChessEngineUCI * self;
	self = (ChessEngineUCI*) base;
	if (g_strcmp0 (self->priv->moves, "") != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat ("position startpos moves", self->priv->moves, NULL);
		chess_engine_write_line ((ChessEngine*) self, _tmp0_);
		_g_free0 (_tmp0_);
	} else {
		chess_engine_write_line ((ChessEngine*) self, "position startpos");
	}
	self->priv->waiting_for_move = TRUE;
	chess_engine_write_line ((ChessEngine*) self, "go wtime 30000 btime 30000");
}


static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move) {
	ChessEngineUCI * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (ChessEngineUCI*) base;
	g_return_if_fail (move != NULL);
	_tmp0_ = chess_move_get_engine (move);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (" ", _tmp1_, NULL);
	_tmp3_ = g_strconcat (self->priv->moves, _tmp2_, NULL);
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp3_;
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void chess_engine_uci_real_undo (ChessEngine* base) {
	ChessEngineUCI * self;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self = (ChessEngineUCI*) base;
	if (self->priv->waiting_for_move) {
		chess_engine_write_line ((ChessEngine*) self, "stop");
	}
	self->priv->waiting_for_move = FALSE;
	_tmp0_ = string_last_index_of (self->priv->moves, " ", 0);
	_tmp1_ = string_slice (self->priv->moves, (glong) 0, (glong) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp2_;
}


static gchar* _vala_array_dup8 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1) {
	ChessEngineUCI * self;
	gint current;
	gint _tmp0_;
	self = (ChessEngineUCI*) base;
	current = self->priv->buffer_length1;
	_tmp0_ = (gint) (self->priv->buffer_length1 + data_length1);
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (self->priv->buffer_length1 + data_length1));
	(_tmp0_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp0_ - self->priv->buffer_length1)) : NULL;
	self->priv->buffer_length1 = _tmp0_;
	self->priv->_buffer_size_ = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < data_length1)) {
					break;
				}
				self->priv->buffer[current + i] = data[i];
			}
		}
	}
	while (TRUE) {
		gint offset = 0;
		gchar* _tmp4_;
		gchar* line;
		gchar** _tmp5_;
		gchar** _tmp6_ = NULL;
		gchar** tokens;
		gint tokens_length1;
		gint _tokens_size_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		{
			gboolean _tmp2_;
			offset = 0;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				if (!_tmp2_) {
					offset++;
				}
				_tmp2_ = FALSE;
				if (offset < self->priv->buffer_length1) {
					_tmp3_ = self->priv->buffer[offset] != '\n';
				} else {
					_tmp3_ = FALSE;
				}
				if (!_tmp3_) {
					break;
				}
			}
		}
		if (offset >= self->priv->buffer_length1) {
			return;
		}
		self->priv->buffer[offset] = '\0';
		_tmp4_ = g_strdup ((const gchar*) self->priv->buffer);
		line = _tmp4_;
		g_debug ("chess-engine-uci.vala:69: Read from engine: '%s'", line);
		_tmp6_ = _tmp5_ = g_strsplit (line, " ", 0);
		tokens = _tmp6_;
		tokens_length1 = _vala_array_length (_tmp5_);
		_tokens_size_ = _vala_array_length (_tmp5_);
		if (tokens_length1 > 0) {
			const gchar* _tmp7_;
			GQuark _tmp8_;
			static GQuark _tmp8__label0 = 0;
			static GQuark _tmp8__label1 = 0;
			static GQuark _tmp8__label2 = 0;
			static GQuark _tmp8__label3 = 0;
			static GQuark _tmp8__label4 = 0;
			static GQuark _tmp8__label5 = 0;
			_tmp7_ = tokens[0];
			_tmp8_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
			if (_tmp8_ == ((0 != _tmp8__label0) ? _tmp8__label0 : (_tmp8__label0 = g_quark_from_static_string ("id")))) {
				switch (0) {
					default:
					{
						break;
					}
				}
			} else if (_tmp8_ == ((0 != _tmp8__label1) ? _tmp8__label1 : (_tmp8__label1 = g_quark_from_static_string ("uciok")))) {
				switch (0) {
					default:
					{
						if (tokens_length1 != 1) {
							g_warning ("chess-engine-uci.vala:81: Unexpected arguments on uciok: %s", line);
						}
						chess_engine_uci_configure (self);
						break;
					}
				}
			} else if (_tmp8_ == ((0 != _tmp8__label2) ? _tmp8__label2 : (_tmp8__label2 = g_quark_from_static_string ("readyok")))) {
				switch (0) {
					default:
					{
						if (tokens_length1 != 1) {
							g_warning ("chess-engine-uci.vala:88: Unexpected arguments on readyok: %s", line);
						}
						chess_engine_set_ready ((ChessEngine*) self, TRUE);
						break;
					}
				}
			} else if (_tmp8_ == ((0 != _tmp8__label3) ? _tmp8__label3 : (_tmp8__label3 = g_quark_from_static_string ("bestmove")))) {
				switch (0) {
					default:
					{
						if (tokens_length1 < 2) {
							g_warning ("chess-engine-uci.vala:95: No move with bestmove: %s", line);
						}
						g_debug ("chess-engine-uci.vala:96: Engine moves %s", tokens[1]);
						self->priv->waiting_for_move = FALSE;
						g_signal_emit_by_name ((ChessEngine*) self, "moved", tokens[1]);
						break;
					}
				}
			} else if (_tmp8_ == ((0 != _tmp8__label4) ? _tmp8__label4 : (_tmp8__label4 = g_quark_from_static_string ("info")))) {
				switch (0) {
					default:
					{
						break;
					}
				}
			} else if (_tmp8_ == ((0 != _tmp8__label5) ? _tmp8__label5 : (_tmp8__label5 = g_quark_from_static_string ("option")))) {
				switch (0) {
					default:
					{
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						g_warning ("chess-engine-uci.vala:108: Unknown command: '%s'", line);
						break;
					}
				}
			}
		}
		_tmp9_ = (_tmp10_ = self->priv->buffer + (offset + 1), (_tmp10_ == NULL) ? ((gpointer) _tmp10_) : _vala_array_dup8 (_tmp10_, self->priv->buffer_length1 - (offset + 1)));
		_tmp11_ = _tmp9_;
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer_length1 = self->priv->buffer_length1 - (offset + 1);
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		self->priv->buffer = _tmp11_;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
}


static void chess_engine_uci_configure (ChessEngineUCI* self) {
	g_return_if_fail (self != NULL);
	{
		gchar** o_collection;
		int o_collection_length1;
		int o_it;
		o_collection = self->priv->options;
		o_collection_length1 = self->priv->options_length1;
		for (o_it = 0; o_it < self->priv->options_length1; o_it = o_it + 1) {
			gchar* _tmp0_;
			gchar* o;
			_tmp0_ = g_strdup (o_collection[o_it]);
			o = _tmp0_;
			{
				gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				_tmp1_ = g_strdup_printf ("setoption %s", o);
				_tmp2_ = _tmp1_;
				chess_engine_write_line ((ChessEngine*) self, _tmp2_);
				_g_free0 (_tmp2_);
				_g_free0 (o);
			}
		}
	}
	chess_engine_write_line ((ChessEngine*) self, "isready");
}


static void chess_engine_uci_class_init (ChessEngineUCIClass * klass) {
	chess_engine_uci_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEngineUCIPrivate));
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_uci_real_start_game;
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_uci_real_request_move;
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_uci_real_report_move;
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_uci_real_undo;
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_uci_real_process_input;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_uci_finalize;
}


static void chess_engine_uci_instance_init (ChessEngineUCI * self) {
	self->priv = CHESS_ENGINE_UCI_GET_PRIVATE (self);
}


static void chess_engine_uci_finalize (GObject* obj) {
	ChessEngineUCI * self;
	self = CHESS_ENGINE_UCI (obj);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	_g_free0 (self->priv->moves);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (chess_engine_uci_parent_class)->finalize (obj);
}


GType chess_engine_uci_get_type (void) {
	static volatile gsize chess_engine_uci_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_uci_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineUCIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_uci_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineUCI), 0, (GInstanceInitFunc) chess_engine_uci_instance_init, NULL };
		GType chess_engine_uci_type_id;
		chess_engine_uci_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineUCI", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_uci_type_id__volatile, chess_engine_uci_type_id);
	}
	return chess_engine_uci_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



