--TEST--
bcceil() function
--EXTENSIONS--
bcmath
--FILE--
<?php
$nums = [
    '0',
    '0.00',
    '-0',
    '-0.00',
    '0.01',
    '0.000000000000000000000000000000000000000001',
    '-0.01',
    '-0.000000000000000000000000000000000000000001',
    '1',
    '1.0000',
    '1.0001',
    '100000.000000000000000000000000000000000000000001',
    '-1',
    '-1.0000',
    '-1.0001',
    '-100000.000000000000000000000000000000000000000001',
];

foreach ($nums as $num) {
    echo str_pad("$num", 50, ' ', STR_PAD_LEFT), ' => ', bcceil($num), "\n";
}
?>
--EXPECT--
                                                 0 => 0
                                              0.00 => 0
                                                -0 => 0
                                             -0.00 => 0
                                              0.01 => 1
      0.000000000000000000000000000000000000000001 => 1
                                             -0.01 => 0
     -0.000000000000000000000000000000000000000001 => 0
                                                 1 => 1
                                            1.0000 => 1
                                            1.0001 => 2
 100000.000000000000000000000000000000000000000001 => 100001
                                                -1 => -1
                                           -1.0000 => -1
                                           -1.0001 => -1
-100000.000000000000000000000000000000000000000001 => -100000
