/*
 * Remote Laboratory GPIB Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#include <tqsocket.h>
#include <tqserversocket.h>
#include <tqapplication.h>
#include <tqvbox.h>
#include <tqtextview.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqtextstream.h>

#include <ksimpleconfig.h>

#include <tdekrbserversocket.h>

#include <tqtrla.h>

#define MAGIC_NUMBER 1
#define PROTOCOL_VERSION 1

class GPIBServer;

class GPIBSocket : public TDEKerberosServerSocket
{
	Q_OBJECT

	public:
		GPIBSocket(int sock, TQObject *parent=0, const char *name=0);
		~GPIBSocket();

	public:
		void close();
		void initiateKerberosHandshake();
		int enterCommandLoop();

	private slots:
		void finishKerberosHandshake();
		void connectionClosedHandler();
		void commandLoop();
	
	private:
		int line;
		int m_criticalSection;
		TQString m_remoteHost;

		TQTimer* m_kerberosInitTimer;
		TQTimer* m_loopTimer;
		TQTimer* m_servClientTimeout;

		KSimpleConfig* m_config;
		GPIBServer* m_serverParent;
		int m_commandLoopState;
		int m_activeDeviceType;
		TQString m_instrumentCommand;

		friend class GPIBServer;
};

class GPIBServer : public TQServerSocket
{
	Q_OBJECT

	public:
		GPIBServer(TQObject* parent=0, int port=0, KSimpleConfig* config=0);
		~GPIBServer();
	
		void newConnection(int socket);

	private slots:
		void remoteConnectionClosed();

	private:
		int readConfig(void);
	
	signals:
		void newConnect(GPIBSocket*);

	private:
		KSimpleConfig* m_config;
		int m_numberOfConnections;

		TQString m_serialDevice;
		long m_serialBaud;
		int m_serialDeviceSocket;

		TQString m_scopeType;
		TQString m_scopeConnection;
		int m_scopeBoard;
		int m_scopeDevice;
		int m_scopeDeviceSocket;

		TQString m_funcgenType;
		TQString m_funcgenConnection;
		int m_funcgenBoard;
		int m_funcgenDevice;
		int m_funcgenDeviceSocket;
	
		TQString m_commanalyzerType;
		TQString m_commanalyzerConnection;
		int m_commanalyzerBoard;
		int m_commanalyzerDevice;
		int m_commanalyzerDeviceSocket;

		TQString m_companalyzerType;
		TQString m_companalyzerConnection;
		int m_companalyzerBoard;
		int m_companalyzerDevice;
		int m_companalyzerDeviceSocket;

		friend class GPIBSocket;

};