#
# spec file for package libheimdal
#
# Copyright (c) 2019 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           libheimdal
Summary:        The Heimdal implementation of the Kerberos 5 protocol
License:        BSD-3-Clause
Group:          Productivity/Networking/Security
Version:        7.7.0
Release:        bp153.1.19
Url:            http://www.h5l.org
# patched source can be created with script heimdal-patch-source.sh:
# ./heimdal-patch-source.sh heimdal-%{version}.tar.gz
Source0:        heimdal-%{version}-patched.tar.bz2
Source2:        heimdal-patch-source.sh
Patch0:         heimdal-patched.diff
# PATCH-FIX-UPSTREAM bmwiedemann -- make build reproducible (boo#1047218)
Patch1:         reproducible.patch
%if 0%{?sles_version} == 11
BuildRequires:  libcom_err-devel
BuildRequires:  sqlite3-devel
%else
BuildRequires:  pkgconfig(com_err)
BuildRequires:  pkgconfig(sqlite3)
%endif
%if 0%{suse_version} > 1315
BuildRequires:  pkgconfig(ncurses) >= 5.3
%else
BuildRequires:  ncurses-devel >= 5.3
%endif
BuildRequires:  automake >= 1.11
BuildRequires:  bison
BuildRequires:  db-devel >= 4.8
BuildRequires:  flex
BuildRequires:  libtool
BuildRequires:  pam-devel
BuildRequires:  pkg-config
BuildRequires:  readline-devel
BuildRequires:  texinfo
BuildRequires:  perl(JSON)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
Heimdal is an implementation of Kerberos 5 (and some more stuff) largely written
in Sweden (which was important when we started writing it, less so now).
It is freely available under a three clause BSD style license.

Other free implementations include the one from MIT, and Shishi.
Also Microsoft Windows and Sun's Java come with implementations of Kerberos.

This package only provides libraries and devel files (binaries have been removed),
libraries are required by 64-bit package of ICAClient version 13.2.

%package devel
Summary:        The Heimdal implementation of the Kerberos 5 protocol
Group:          Development/Libraries/C and C++
Requires:       libheimdal = %{version}
%if 0%{?sles_version} == 11
Requires:       libcom_err-devel
Requires:       sqlite3-devel
%else
Requires:       pkgconfig(com_err)
Requires:       pkgconfig(sqlite3)
%endif
%if 0%{suse_version} > 1315
Requires:       pkgconfig(ncurses) >= 5.3
%else
Requires:       ncurses-devel >= 5.3
%endif
Requires:       db-devel >= 4.8
Requires:       glibc-devel
Conflicts:      krb5-devel
Conflicts:      krb5-mini-devel

%description devel
Heimdal is an implementation of Kerberos 5 (and some more stuff) largely written
in Sweden (which was important when we started writing it, less so now).
It is freely available under a three clause BSD style license.

Other free implementations include the one from MIT, and Shishi.
Also Microsoft Windows and Sun's Java come with implementations of Kerberos.

This package only provides libraries and devel files (binaries have been removed),
libraries are required by 64-bit package of ICAClient version 13.2.

%prep
%setup -q -n heimdal-%{version}
%patch0 -p1
%patch1 -p1

%build
export SOURCE_HOST=OBS # for reproducible builds (boo#1084909)
autoreconf -fi
%configure \
  --with-sqlite3=%{_prefix}
make %{?_smp_mflags}

%install
%make_install

rm -rf %{buildroot}%{_libdir}/*.a
rm -rf %{buildroot}%{_libdir}/*.la

%post
/sbin/ldconfig
%install_info --info-dir=%{_infodir} %{_infodir}/heimdal.info.gz
%install_info --info-dir=%{_infodir} %{_infodir}/hx509.info.gz

%postun -p /sbin/ldconfig

%preun
/sbin/ldconfig
%install_info_delete --info-dir=%{_infodir} %{_infodir}/heimdal.info.gz
%install_info_delete --info-dir=%{_infodir} %{_infodir}/hx509.info.gz

%files
%defattr(-,root,root)
%doc LICENSE NEWS README TODO
%{_libdir}/libasn1.so.8*
%{_libdir}/libgssapi.so.3*
%{_libdir}/libhcrypto.so.4*
%{_libdir}/libhdb.so.9*
%{_libdir}/libheimbase.so.1*
%{_libdir}/libheimedit.so.0*
%{_libdir}/libheimntlm.so.0*
%{_libdir}/libhx509.so.5*
%{_libdir}/libkadm5clnt.so.7*
%{_libdir}/libkadm5srv.so.8*
%{_libdir}/libkafs.so.0*
%{_libdir}/libkdc.so.2*
%{_libdir}/libkrb5.so.26*
%{_libdir}/libotp.so.0*
%{_libdir}/libroken.so.18*
%{_libdir}/libsl.so.0*
%{_libdir}/libwind.so.0*
%{_infodir}/*.info.gz

%files devel
%defattr(-,root,root)
%doc LICENSE
%{_includedir}/*.h
%dir %{_includedir}/gssapi
%{_includedir}/gssapi/*.h
%dir %{_includedir}/hcrypto
%{_includedir}/hcrypto/*.h
%dir %{_includedir}/kadm5
%{_includedir}/kadm5/*.h
%dir %{_includedir}/krb5
%{_includedir}/krb5/*.h
%dir %{_includedir}/roken
%{_includedir}/roken/*.h
%{_libdir}/*.so

%changelog
* Sun Jun 23 2019 enzokiel@kabelmail.de
- Update to version 7.7.0
  + Bug fixes:
  - PKCS#11 hcrypto back-end:
    + initialize the p11_module_load function list
    + verify that not only is a mechanism present but that its
    mechanism info states that it offers the required
    encryption, decryption or digest services
  - krb5:
    + Starting with 7.6, Heimdal permitted requesting
    authenticated anonymous tickets. However, it did not
    verify that a KDC in fact returned an anonymous ticket
    when one was requested.
    + Cease setting the KDCOption reaquest_anonymous flag when
    issuing S4UProxy (constrained delegation) TGS requests.
    + when the Win2K PKINIT compatibility option is set, do not
    require krbtgt otherName to match when validating KDC
    certificate.
    + set PKINIT_BTMM flag per Apple implementation
    + use memset_s() instead of memset()
  - kdc:
    + When generating KRB5SignedPath in the AS, use the reply
    client name rather than the one from the request, so
    validation will work correctly in the TGS.
    + allow checksum of PA-FOR-USER to be HMAC_MD5. Even if TGT
    used an enctype with a different checksum. Per [MS-SFU]
    2.2.1 PA-FOR-USER the checksum is always HMAC_MD5, and
    that's what Windows and MIT clients send.
    In Heimdal both the client and kdc use instead the
    checksum of the TGT, and therefore work with each other
    but Windows and MIT clients fail against Heimdal KDC.
    Both Windows and MIT KDC would allow any keyed checksum
    to be used so Heimdal client work fine against it.
    Change Heimdal KDC to allow HMAC_MD5 even for non RC4
    based TGT in order to support per-spec clients.
    + use memset_s() instead of memset()
    + Detect Heimdal 1.0 through 7.6 clients that issue
    S4UProxy (constrained delegation) TGS Requests with the
    request anonymous flag set. These requests will be
    treated as S4UProxy requests and not anonymous requests.
  - HDB:
    + Set SQLite3 backend default page size to 8KB.
    + Add hdb_set_sync() method
  - kadmind:
    + disable HDB sync during database load avoiding
    unnecessary disk i/o.
  - ipropd:
    + disable HDB sync during receive_everything. Doing an
    fsync per-record when receiving the complete HDB is a
    performance disaster. Among other things, if the HDB is
    very large, then one slave receving a full HDB can cause
    other slaves to timeout and, if HDB write activity is
    high enough to cause iprop log truncation, then also need
    full syncs, which leads to a cycle of full syncs for all
    slaves until HDB write activity drops.
    Allowing the iprop log to be larger helps, but improving
    receive_everything() performance helps even more.
  - kinit:
    + Anonymous PKINIT tickets discard the realm information
    used to locate the issuing AS. Store the issuing realm in
    the credentials cache in order to locate a KDC which can
    renew them.
    + Do not leak the result of krb5_cc_get_config() when
    determining anonymous PKINIT start realm.
  - klist:
    + Show transited-policy-checked, ok-as-delegate and
    anonymous flags when listing credentials.
  - tests:
    + Regenerate certs so that they expire before the 2038
    armageddon so the test suite will pass on 32-bit
    operating systems until the underlying issues can be
    resolved.
  - Solaris:
    + Define _STDC_C11_BCI for memset_s prototype
  - build tooling:
    + Convert from python 2 to python 3
  - documentation:
    + rename verify-password to verify-password-quality
    + hprop default mode is encrypt
    + kadmind "all" permission does not include "get-keys"
    + verify-password-quality might not be stateless
- Version 7.6.0
  + Security (#555):
  - CVE-2018-16860 Heimdal KDC: Reject PA-S4U2Self with unkeyed
    checksum
    When the Heimdal KDC checks the checksum that is placed on
    the S4U2Self packet by the server to protect the requested
    principal against modification, it does not confirm that
    the checksum algorithm that protects the user name
    (principal) in the request is keyed. This allows a
    man-in-the-middle attacker who can intercept the request to
    the KDC to modify the packet by replacing the user name
    (principal) in the request with any desired user name
    (principal) that exists in the KDC and replace the checksum
    protecting that name with a CRC32 checksum (which requires
    no prior knowledge to compute).
    This would allow a S4U2Self ticket requested on behalf of
    user name (principal) user@EXAMPLE.COM to any service to be
    changed to a S4U2Self ticket with a user name (principal) of
    Administrator@EXAMPLE.COM. This ticket would then contain
    the PAC of the modified user name (principal).
  - CVE-2019-12098, client-only:
    RFC8062 Section 7 requires verification of the PA-PKINIT-KX
    key exchange when anonymous PKINIT is used. Failure to do
    so can permit an active attacker to become a
    man-in-the-middle.
  + Bug fixes:
  - Happy eyeballs: Don't wait for responses from
    known-unreachable KDCs.
  - kdc:
    + check return copy_Realm, copy_PrincipalName,
    copy_EncryptionKey
  - kinit:
    + cleanup temporary ccaches
    + see man page for "kinit --anonymous" command line syntax
    change
  - kdc:
    + Make anonymous AS-requests more RFC8062-compliant.
    Updated expired test certificates
  - Solaris:
    + PKCS#11 hcrypto backend broken since 7.0.1
    + Building with Sun Pro C
  + Features:
  - kuser: support authenticated anonymous AS-REQs in kinit
  - kdc: support for anonymous TGS-REQs
  - kgetcred support for anonymous service tickets
  - Support builds with OpenSSL 1.1.1
- fixed heimdal-patched.diff and reproducible.patch
* Tue Aug  7 2018 bwiedemann@suse.com
- Add reproducible.patch to override build date (boo#1047218)
- Use constant hostname (boo#1084909)
* Fri Dec 29 2017 joerg.lorenzen@ki.tng.de
- Update to version 7.5.0
  - Security
  - Fix CVE-2017-17439, which is a remote denial of service
    vulnerability:
    In Heimdal 7.1 through 7.4, remote unauthenticated attackers
    are able to crash the KDC by sending a crafted UDP packet
    containing empty data fields for client name or realm.
  - Bug fixes
  - Handle long input lines when reloading database dumps.
  - In pre-forked mode (default on Unix), correctly clear the
    process ids of exited children, allowing new child processes
    to replace the old.
  - Fixed incorrect KDC response when no-cross realm TGT exists,
    allowing client requests to fail quickly rather than time
    out after trying to get a correct answer from each KDC.
- Fixed heimdal-patched.diff.
- Removed Avoid_NULL_structure_pointer_member_dereference.patch,
  fixed upstream.
* Thu Dec  7 2017 joerg.lorenzen@ki.tng.de
- Added Avoid_NULL_structure_pointer_member_dereference.patch,
  fixes (bsc#1071675).
* Thu Aug  3 2017 joerg.lorenzen@ki.tng.de
- Update to version 7.4.0
  - Security
  - Fix CVE-2017-11103: Orpheus' Lyre KDC-REP service name
    validation.
    This is a critical vulnerability.
    In _krb5_extract_ticket() the KDC-REP service name must be
    obtained from encrypted version stored in 'enc_part' instead
    of the unencrypted version stored in 'ticket'.
    Use of the unecrypted version provides an opportunity for
    successful server impersonation and other attacks.
    Identified by Jeffrey Altman, Viktor Duchovni and
    Nico Williams.
    See https://www.orpheus-lyre.info/ for more details.
- Fixed heimdal-patched.diff.
* Thu Jun 15 2017 joerg.lorenzen@ki.tng.de
- Update to version 7.3.0
  - Security
    + Fix transit path validation. Commit f469fc6 (2010-10-02)
    inadvertently caused the previous hop realm to not be added
    to the transit path of issued tickets. This may, in some
    cases, enable bypass of capath policy in Heimdal versions 1.5
    through 7.2.
    Note, this may break sites that rely on the bug. With the bug
    some incomplete [capaths] worked, that should not have.
    These may now break authentication in some cross-realm
    configurations. (CVE-2017-6594)
- Version 7.2.0
  - Bug fixes
    + Portability improvements.
    + More strict parsing of encoded URI components in HTTP KDC.
    + Fixed memory leak in malloc error recovery in NTLM GSSAPI
    mechanism.
    + Avoid overly specific CPU info in krb5-config in aid of
    reproducible builds.
    + Don't do AFS string-to-key tests when feature is disabled.
    + Skip mdb_stat test when the command is not available.
    + Windows: update SHA2 timestamp server.
    + hdb: add missing export
    hdb_generate_key_set_password_with_ks_tuple.
    + Fix signature of hdb_generate_key_set_password().
    + Windows: enable KX509 support in the KDC.
    + kdc: fix kx509 service principal match.
    + iprop: handle case where master sends nothing new.
    + ipropd-slave: fix incorrect error codes.
    + Allow choice of sqlite for HDB pref.
    + check-iprop: don't fail to kill daemons.
    + roken: pidfile -> rk_pidfile.
    + kdc: _kdc_do_kx509 fix use after free error.
    + Do not detect x32 as 64-bit platform.
    + No sys/ttydefaults.h on CYGWIN.
    + Fix check-iprop races.
    + roken_detach_prep() close pipe.
- Fixed heimdal-patched.diff.
* Thu Feb  2 2017 jengelh@inai.de
- Summary and RPM group update. Do a direct call to ldconfig
  where possible.
* Sat Jan  7 2017 joerg.lorenzen@ki.tng.de
- Update to version 7.1.0
- Removed heimdal-version-script-client.map.patch, fixed upstream.
- Fixed heimdal-patched.diff.
- Unfortunately there is no updated changelog file in tarball,
  changes can be seen in source code version control systems
  history log.
* Sat Sep  5 2015 joerg.lorenzen@ki.tng.de
- Added a patched instead of the original tarball because only
  shared libraries will be build and source files of these (not to
  be build) programs have problematic licenses.
- Added script heimdal-patch-source.sh to sources.
- Added patch heimdal-patched.diff that fixes configure.ac and
  several Makefile.am files to successfully build patched source.
- Removed unneeded dependencies in spec file for build.
* Wed Sep  2 2015 joerg.lorenzen@ki.tng.de
- Added Conflicts tags to spec file because devel package conflicts
  with krb5-devel and krb5-mini-devel.
* Tue Sep  1 2015 joerg.lorenzen@ki.tng.de
- Some changes in spec file to enable build for SLES.
* Sun Aug 30 2015 joerg.lorenzen@ki.tng.de
- Initial package, version 1.6rc2
- Added patch heimdal-version-script-client.map.patch to add file
  version-script-client.map (File is present in git for tag 1.6rc2
  but missing in tarball).
