# Copyright 2022-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="dependencies"
PYTHON_COMPAT=( python3_{11..14} )

inherit trinity-base-2 python-single-r1 toolchain-funcs

DESCRIPTION="Python/C++ bindings generator runtime library"
HOMEPAGE="https://trinitydesktop.org"
LICENSE="|| ( GPL-2 GPL-3 SIP )"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="${PYTHON_DEPS}
	~x11-libs/tqscintilla-${PV}
	~dev-tqt/tqtinterface-${PV}
"
RDEPEND="${DEPEND}"
BDEPEND="
	$(python_gen_cond_dep '
		dev-python/setuptools[${PYTHON_USEDEP}]
	')
"

TQTDIR="/usr/tqt3"
BUILD_DIR="${S}"

src_prepare() {
	default
}

src_configure() {
	local myconf
	myconf=(
		# compiller
		CC="$(tc-getCC)"
		CXX="$(tc-getCXX)"
		LINK="$(tc-getCXX)"
		LINK_SHLIB="$(tc-getCXX)"
		# flags
		CFLAGS="${CFLAGS}"
		CXXFLAGS="${CXXFLAGS}"
		INCDIR="/usr/include/tqt /${TQTDIR}/include"
		# supress stip
		STRIP="true"
	)
	"${EPYTHON}" configure.py "${myconf[@]}" || die
}

src_compile() {
	emake
}

src_install() {
	emake install DESTDIR="${D}"
	python_optimize
}
