/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef INTEGRATORDLG_H
#define INTEGRATORDLG_H

#include "integratordlgbase.h"
#include "cvsserviceintegrator.h"

class TQDomDocument;

class IntegratorDlg: public IntegratorDlgBase, public VCSDialog {
TQ_OBJECT
  
public:
    IntegratorDlg(CVSServiceIntegrator *integrator, TQWidget *parent = 0, const char *name = 0);

    virtual TQWidget *self();
    virtual void init(const TQString &projectName, const TQString &projectLocation);

public slots:
    virtual void login_clicked();
    virtual void init_clicked();
    virtual void accept();
    virtual void createModule_clicked();

private:
    CVSServiceIntegrator *m_integrator;
    TQString m_projectLocation;
    TQString m_projectName;
};

#endif
