/***************************************************************************
 *   Copyright (C) 2004 by ian reinhart geiser                             *
 *   geiseri@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef __SPECSUPPORT_H__
#define __SPECSUPPORT_H__

#include <tqstring.h>
#include <tqmap.h>
#include "packagebase.h"
#include "distpart_part.h"
#include "distpart_widget.h"

class SpecSupport : public packageBase {

public:
    SpecSupport(DistpartPart *part);
    ~SpecSupport();

public:
    TQString generatePackage();
    void slotbuildAllPushButtonPressed();
    void slotexportSPECPushButtonPressed();
    void slotimportSPECPushButtonPressed();
    void slotsrcPackagePushButtonPressed();
	void slotAddFileButtonPressed();

private:
    void parseDotRpmmacros();
    bool createRpmDirectoryFromMacro(const TQString & name);

    TQString getInfo(TQString s, TQString motif);

    TQString dir;
    DistpartPart *m_part;
    TQMap<TQString,TQString> map;
};

#endif
