/***************************************************************************

                   base class for query dialogs

    -----------------------------------------------------------------------

    begin          : Thu Nov 25 20:50:53 MET 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef Query_Dlg_Base_H
#define Query_Dlg_Base_H

#include <time.h>
#include <stdlib.h>

#include <kdialogbase.h>

#include <QueryManager.h>
#include <grammarmanager.h>

class kvoctrainExpr;
class kvoctrainDoc;

class TQLineEdit;
class TQMultiLineEdit;
class TQLabel;
class TQRadioButton;

class QueryDlgBase : public KDialogBase
{

  TQ_OBJECT
  

public:
  enum Result { Unknown, Known, Timeout, StopIt };

  QueryDlgBase(const TQString & caption, TQWidget *parent = 0, const char *name = 0, bool modal = false);

  virtual ~QueryDlgBase ();

  bool smartCompare (const TQString&, const TQString&, int level) const;

  bool verifyField(TQLineEdit *field, const TQString &really);
  void resetField (TQLineEdit *field);

  bool verifyField(TQMultiLineEdit *field, const TQString &really,
                    bool mixed);
  void resetField (TQMultiLineEdit *field);

  void verifyButton(TQRadioButton *radio, bool is_ok, TQWidget *widget2 = 0);
  void resetButton (TQRadioButton *radio, TQWidget *widget2 = 0);

  // Show string after selceting known/unknown
  // depending on progress and randomness
  TQString  getOKComment(int percent);
  TQString  getNOKComment(int percent);
  TQString  getTimeoutComment(int percent);

  int getRandom(int range)
    {
//        srand((unsigned int)time((time_t *)NULL));
        return (int) (range * ((1.0*rand())/RAND_MAX));
    }

  virtual void initFocus() const;

signals:
  void sigQueryChoice(QueryDlgBase::Result);
  void sigEditEntry(int row, int col);

protected:
  virtual void closeEvent(TQCloseEvent*e);
  virtual void slotUser1();

  struct RB_Label {
    RB_Label (TQRadioButton* _rb, TQLabel *_label)
      : rb(_rb), label(_label) {}

    TQRadioButton  *rb;
    TQLabel        *label;
  };

  int            q_row,
                 q_ocol,
                 q_tcol;
  kvoctrainDoc  *kv_doc;
  kvoctrainExpr *kv_exp;
  TQString        translation;
  TQTimer        *qtimer;
  int            timercount;
};


#endif // Query_Dlg_Base_H
