//
// C++ Interface: mallorybutton
//
// Description:
//
//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MALLORYBUTTON_H
#define MALLORYBUTTON_H

#include <tqbutton.h>

#include "malloryclient.h"
#include "enums.h"

class MalloryClient;

class MalloryButton : public TQButton
{
TQ_OBJECT
public:
	MalloryButton(MalloryClient *parent = 0, const char *name = 0, const TQString &tip=NULL, ButtonType type = (ButtonType)0);
	~MalloryButton();

	void setTipText(const TQString &tip);

	void setOnAllDesktops(bool oad)	{ isOnAllDesktops = oad; repaint(false); }
	void setMaximized(bool max) { isMaximized = max; repaint(false); }
	TQSize sizeHint() const;
	int lastMousePress() const { return m_lastMouse; }
	void reset() { repaint(false); }
	MalloryClient* client() { return m_client; }

private:
	void enterEvent(TQEvent *e);
	void leaveEvent(TQEvent *e);
	void mousePressEvent(TQMouseEvent *e);
	void mouseReleaseEvent(TQMouseEvent *e);
	void drawButton(TQPainter *painter);

	MalloryClient *m_client;
	int m_lastMouse;
	ButtonType m_type;
	bool hover;
	bool isOnAllDesktops, isMaximized;
};

#endif
