/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "actionregistry.h"
#include "katapultaction.h"
#include "katapultitem.h"

static ActionRegistry * actionRegistryInstance = 0;

ActionRegistry::ActionRegistry()
{
	actions.setAutoDelete(true);
}

ActionRegistry::~ActionRegistry()
{
}

ActionRegistry * ActionRegistry::self()
{
	if(actionRegistryInstance == 0)
		actionRegistryInstance = new ActionRegistry();
	return actionRegistryInstance;
}

void ActionRegistry::registerAction(const KatapultAction *action)
{
	actions.append(action);
}

TQPtrList<KatapultAction> ActionRegistry::actionsForItem(const KatapultItem *item) const
{
	TQPtrList<KatapultAction> result;
	TQPtrListIterator<KatapultAction> it(actions);
	KatapultAction *action;
	while((action = it.current()) != 0) {
		++it;
		if(action->accepts(item))
			result.append(action);
	}
	return result;
}

void ActionRegistry::clear()
{
	actions.clear();
}
