/* This file is part of the KDE project
   Copyright (C) 2002, 2003 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kexidragobjects.h"

#include <tqcstring.h>
#include <tqdatastream.h>
#include <kdebug.h>

/// implementation of KexiFieldDrag

KexiFieldDrag::KexiFieldDrag(const TQString& sourceMimeType, const TQString& sourceName, 
	const TQString& field, TQWidget *parent, const char *name)
 : TQStoredDrag("kexi/field", parent, name)
{
	TQByteArray data;
	TQDataStream stream1(data,IO_WriteOnly);
	stream1 << sourceMimeType << sourceName << field;
	setEncodedData(data);
}

KexiFieldDrag::KexiFieldDrag(const TQString& sourceMimeType, const TQString& sourceName, 
	const TQStringList& fields, TQWidget *parent, const char *name)
 : TQStoredDrag((fields.count() > 1) ? "kexi/fields" : "kexi/field", parent, name)
{
	TQByteArray data;
	TQDataStream stream1(data,IO_WriteOnly);
	if (fields.count() > 1)
		stream1 << sourceMimeType << sourceName << fields;
	else {
		TQString field;
		if (fields.count() == 1)
			field = fields.first();
		else
			kexidbg << "KexiFieldDrag::KexiFieldDrag(): fields list is empty!" << endl;
		stream1 << sourceMimeType << sourceName << field;
	}
	setEncodedData(data);
}

KexiFieldDrag::~KexiFieldDrag()
{
}

bool
KexiFieldDrag::canDecodeSingle(TQMimeSource *e)
{
	return e->provides("kexi/field");
}

bool
KexiFieldDrag::canDecodeMultiple(TQMimeSource *e)
{
	return e->provides("kexi/field") || e->provides("kexi/fields");
}

bool
KexiFieldDrag::decodeSingle( TQDropEvent* e, TQString& sourceMimeType, 
	TQString& sourceName, TQString& field )
{
	TQByteArray payload( e->data("kexi/field") );
	if (payload.isEmpty())
		return false;
	e->accept();
	TQDataStream stream1(payload, IO_ReadOnly);
	stream1 >> sourceMimeType;
	stream1 >> sourceName;
	stream1 >> field;
//	kdDebug() << "KexiFieldDrag::decode() decoded: " << sourceMimeType<<"/"<<sourceName<<"/"<<field << endl;
	return true;
}

bool
KexiFieldDrag::decodeMultiple( TQDropEvent* e, TQString& sourceMimeType, 
	TQString& sourceName, TQStringList& fields )
{
	TQByteArray payload( e->data("kexi/fields") );
	if (payload.isEmpty()) {//try single
		TQString field;
		bool res = KexiFieldDrag::decodeSingle( e, sourceMimeType, sourceName, field );
		if (!res)
			return false;
		fields.append(field);
		return true;
	}
	e->accept();
	TQDataStream stream1(payload, IO_ReadOnly);
	stream1 >> sourceMimeType;
	stream1 >> sourceName;
	stream1 >> fields;
//	kdDebug() << "KexiFieldDrag::decode() decoded: " << sourceMimeType<<"/"<<sourceName<<"/"<<fields << endl;
	return true;
}

/// implementation of KexiDataProviderDrag

KexiDataProviderDrag::KexiDataProviderDrag(const TQString& sourceMimeType, const TQString& sourceName,
	TQWidget *parent, const char *name)
 : TQStoredDrag("kexi/dataprovider", parent, name)
{
	TQByteArray data;
	TQDataStream stream1(data,IO_WriteOnly);
	stream1 << sourceMimeType << sourceName;
	setEncodedData(data);
}


bool
KexiDataProviderDrag::canDecode(TQDragMoveEvent *e)
{
	return e->provides("kexi/dataprovider");
}

bool
KexiDataProviderDrag::decode( TQDropEvent* e, TQString& sourceMimeType, TQString& sourceName)
{
	TQCString tmp;
	TQByteArray payload = e->data("kexidataprovider");
	if(payload.size())
	{
		e->accept();
		TQDataStream stream1(payload, IO_ReadOnly);
		stream1 >> sourceMimeType;
		stream1 >> sourceName;
//		kdDebug() << "KexiDataProviderDrag::decode() decoded: " << sourceMimeType <<"/"<<sourceName<< endl;
		return true;
	}
	return false;
}
