#ifndef TQPRO_RECORD_H
#define TQPRO_RECORD_H

#include <qpro/tablenames.h>
#include <qpro/stream.h>

enum QpRecType
{
   QpBof               = 0,
   QpEof               = 1,
   QpRecalcMode        = 2,
   QpRecalcOrder       = 3,
   QpEmptyCell         = 12,
   QpIntegerCell       = 13,
   QpFloatingPointCell = 14,
   QpLabelCell         = 15,
   QpFormulaCell       = 16,
   QpPassword          = 75,
   QpBop               = 202,
   QpPageName          = 204,
   QpUnknown           = -1
};

// -----------------------------------------------------------------------

class QpRec
{
public:
   QpRec(QpRecType pType);
   ~QpRec();

   TQP_INT16 type();

protected:
   TQP_INT16 cType;
};

// -----------------------------------------------------------------------

//class TQP_CELL_REF
//{
//public:
//   TQP_CELL_REF(QpIStream& pIn);
//   ~TQP_CELL_REF();
// 
//   TQP_UINT8 Column();
//   TQP_INT16 Row();
// 
//protected:
//   TQP_UINT8 cColumn;
//   TQP_INT16 cNoteBook;
//   TQP_INT8  cPage;
//   TQP_INT16 cRow;
//};

// -----------------------------------------------------------------------

class QpRecCell : public QpRec
{
public:
   QpRecCell(QpRecType pType);
   ~QpRecCell();

   void        attributes(TQP_INT16 pAttributes);
   TQP_INT16    attributes();
 
//   const char* cellRef();
   void        cellRef(char* pText, QpTableNames& pTable, TQP_INT16 pNoteBook, TQP_UINT8 pPage, TQP_UINT8 pColumn, TQP_INT16 pRow);
   void        cellRef(char* pText, QpTableNames& pTable, QpIStream& pFormulaRef);
 
   void        column(TQP_UINT8 pColumn);
   TQP_UINT8    column();
 
   void        row(TQP_INT16 pRow);
   TQP_INT16    row();

protected:
   int         loadCellInfo(QpIStream& pIn);

   TQP_INT16 cAttributes;
   TQP_UINT8 cColumn;
   TQP_UINT8 cPage;
   TQP_INT16 cRow;
   char*    cCellRef;
};

// -----------------------------------------------------------------------

class QpRecBof : public QpRec
{
public:
   QpRecBof(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecBof();

   void     fileFormat(TQP_INT16 pFileFormat);
   TQP_INT16 fileFormat();

protected:
   TQP_INT16 cFileFormat;
};

// -----------------------------------------------------------------------

class QpRecEof : public QpRec
{
public:
   QpRecEof(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecEof();
};


// -----------------------------------------------------------------------

class QpRecRecalcMode : public QpRec
{
public:
   enum MODE{Manual=0, Background=1, Automatic=255};

   QpRecRecalcMode(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecRecalcMode();

   void mode(MODE pMode);
   MODE mode();

protected:
   MODE cMode;
};


// -----------------------------------------------------------------------

class QpRecRecalcOrder : public QpRec
{
public:
   enum ORDER { Natural=0, Column=1, Row=255 };

   QpRecRecalcOrder(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecRecalcOrder();

   void  order(ORDER pOrder);
   ORDER order();

protected:
   ORDER cOrder;
};


// -----------------------------------------------------------------------

// QpRecDimension
// -----------------------------------------------------------------------

// QpRecName

// -----------------------------------------------------------------------

class QpRecEmptyCell : public QpRecCell
{
public:
   QpRecEmptyCell(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecEmptyCell();
};


// -----------------------------------------------------------------------

class QpRecIntegerCell : public QpRecCell
{
public:
   QpRecIntegerCell(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecIntegerCell();


   TQP_INT16 integer();
protected:
   TQP_INT16 cInt;
};

// -----------------------------------------------------------------------

class QpRecFloatingPointCell : public QpRecCell
{
public:
   QpRecFloatingPointCell(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecFloatingPointCell();
 
   TQP_INT64 value();
protected:
   TQP_INT64 cValue;
};

// -----------------------------------------------------------------------

class QpRecFormulaCell : public QpRecCell
{
public:
   QpRecFormulaCell(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecFormulaCell();
 
   const char* formula();
   TQP_INT16    formulaReferences();
   TQP_INT16    formulaLen();

protected:
   TQP_INT16    cCellRef;
   char*       cFormula;
   TQP_INT64    cLastValue;
   TQP_INT16    cLen;
   TQP_INT16    cState;
};

// -----------------------------------------------------------------------

class QpRecLabelCell : public QpRecCell
{
public:
   QpRecLabelCell(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecLabelCell();
 
   char        labelPrefix();
   const char* label();

protected:
   char  cLabelPrefix;
   char* cLabel;
};                                                                                                                                 

// -----------------------------------------------------------------------

class QpRecUnknown : public QpRec
{
public:
   QpRecUnknown(TQP_INT16 pType, TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecUnknown();
};

// -----------------------------------------------------------------------

class QpRecBop : public QpRec
{
public:
    QpRecBop(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecBop();

   TQP_UINT8 pageIndex();

protected:
   TQP_UINT8 cPageIndex;
};

// -----------------------------------------------------------------------
 
class QpRecPageName : public QpRec
{
public:
    QpRecPageName(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecPageName();
 
   const char* pageName();
 
protected:
   char* cPageName;
};

// -----------------------------------------------------------------------
 
class QpRecPassword : public QpRec
{
public:
   QpRecPassword(TQP_INT16 pLen, QpIStream& pIn);
   ~QpRecPassword();

   const TQP_UINT8* password();

protected:
   TQP_UINT8* cPassword;
};

#endif // TQPRO_RECORD_H

