/* This file is part of the KDE project
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __SVGIMPORT_H__
#define __SVGIMPORT_H__

#include <KoFilter.h>
#include <tqdom.h>
#include <tqmap.h>
#include <tqptrstack.h>
#include <core/vdocument.h>
#include <core/vgradient.h>
#include <core/vfill.h>
#include <core/vstroke.h>
#include <core/vfillrule.h>
#include "svggraphiccontext.h"

#include <vobject.h>

class VGroup;
class VPath;

class SvgImport : public KoFilter
{
	TQ_OBJECT
  

public:
	SvgImport(KoFilter *parent, const char *name, const TQStringList&);
	virtual ~SvgImport();

	virtual KoFilter::ConversionStatus convert(const TQCString& from, const TQCString& to);

protected:
	class GradientHelper
	{
	public:
		GradientHelper()
		{
			bbox = true;
		}
		VGradient	gradient;
		bool		bbox;
		TQWMatrix	gradientTransform;
	};

	void parseGroup( VGroup *, const TQDomElement & );
	void parseDefs( const TQDomElement & );
	void parseUse( VGroup *, const TQDomElement & );
	void parseStyle( VObject *, const TQDomElement & );
	void parsePA( VObject *, SvgGraphicsContext *, const TQString &, const TQString & );
	void parseGradient( const TQDomElement &, const TQDomElement &referencedBy = TQDomElement() );
	void parseColorStops( VGradient *, const TQDomElement & );
	double parseUnit( const TQString &, bool horiz = false, bool vert = false, KoRect bbox = KoRect() );
	void parseColor( VColor &, const TQString & );
	TQColor parseColor( const TQString & );
	double toPercentage( TQString );
	double fromPercentage( TQString );
	void setupTransform( const TQDomElement & );
	void addGraphicContext();
	TQDomDocument inpdoc;
	TQDomDocument outdoc;
	void convert();
	void createObject( VGroup *grp, const TQDomElement &, VObject::VState state = VObject::normal, const TQDomElement &style = TQDomElement() );
	void createText( VGroup *, const TQDomElement & );
	void parseFont( const TQDomElement & );
	// find object with given id in document
	VObject* findObject( const TQString &name );
	// find object with given id in given group
	VObject* findObject( const TQString &name, VGroup * );
	// find gradient with given id in gradient map
	GradientHelper* findGradient( const TQString &id, const TQString &href = 0 );

	// Determine scaling factor from given matrix
	double getScalingFromMatrix( TQWMatrix &matrix );

	TQDomElement mergeStyles( const TQDomElement &, const TQDomElement & );

private:
	VDocument						m_document;
	TQPtrStack<SvgGraphicsContext>	m_gc;
	TQMap<TQString, GradientHelper>	m_gradients;
	TQMap<TQString, TQDomElement>		m_defs;
	KoRect							m_outerRect;
};

#endif
