/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_INSTRUMENTPARAMETERBOX_H_
#define _RG_INSTRUMENTPARAMETERBOX_H_

#include "base/MidiProgram.h"
#include "RosegardenParameterArea.h"
#include "RosegardenParameterBox.h"
#include <tqstring.h>
#include <vector>


class TQWidgetStack;
class TQWidget;
class TQFrame;


namespace Rosegarden
{

class RosegardenGUIDoc;
class MIDIInstrumentParameterPanel;
class Instrument;
class AudioInstrumentParameterPanel;


/**
 * Display and allow modification of Instrument parameters
 */
class InstrumentParameterBox : public RosegardenParameterBox
{
TQ_OBJECT
  

public:
    InstrumentParameterBox(RosegardenGUIDoc *doc,
                           TQWidget *parent = 0);
    ~InstrumentParameterBox();

    void useInstrument(Instrument *instrument);

    Instrument* getSelectedInstrument();

    void setAudioMeter(float dBleft, float dBright,
                       float recDBleft, float recDBright);

    void setDocument(RosegardenGUIDoc* doc);
    
    virtual void showAdditionalControls(bool showThem);

    virtual TQString getPreviousBox(RosegardenParameterArea::Arrangement) const;

public slots:

    // To update all InstrumentParameterBoxen for an Instrument.  Called
    // from one of the parameter panels when something changes.
    //
    void slotUpdateAllBoxes();

    // Update InstrumentParameterBoxes that are showing a given instrument.
    // Called from the Outside.
    //
    void slotInstrumentParametersChanged(InstrumentId id);

    // From Plugin dialog
    //
    void slotPluginSelected(InstrumentId id, int index, int plugin);
    void slotPluginBypassed(InstrumentId id, int pluginIndex, bool bp);

signals:

    void changeInstrumentLabel(InstrumentId id, TQString label);

    void selectPlugin(TQWidget*, InstrumentId id, int index);
    void showPluginGUI(InstrumentId id, int index);

    void instrumentParametersChanged(InstrumentId);
    void instrumentPercussionSetChanged(Instrument *);

protected:

    //--------------- Data members ---------------------------------
    TQWidgetStack                    *m_widgetStack;
    TQFrame                          *m_noInstrumentParameters;
    MIDIInstrumentParameterPanel    *m_midiInstrumentParameters;
    AudioInstrumentParameterPanel   *m_audioInstrumentParameters;

    // -1 if no instrument, InstrumentId otherwise
    int                              m_selectedInstrument;

    // So we can setModified()
    //
    RosegardenGUIDoc                *m_doc;
    bool                            m_lastShowAdditionalControlsArg;
};

// Global references
//
static std::vector<InstrumentParameterBox*> instrumentParamBoxes;


}

#endif
