#################################################
#
#  (C) 2011 Timothy Pearson
#  kb9vqf (AT) pearsoncomputing.net
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


# Initialize some variables
set(HAVE_XFT FALSE)
set(HAVE_ALSA FALSE)
set(HAVE_JACK FALSE)
set(HAVE_DSSI FALSE)
set(HAVE_LIBLO FALSE)
set(HAVE_LIBLRDF FALSE)
set(HAVE_LADSPA FALSE)
set(HAVE_LIRC FALSE)
set(HAVE_FFTW3F FALSE)

# Check for Xft
pkg_check_modules(XFT xft>=2.1.0)
if(XFT_FOUND)
    add_definitions(-DHAVE_XFT)
    set(HAVE_XFT TRUE)
    set(XFT_LIBS ${XFT_LIBRARIES})
    #message("XFT_LIBS: ${XFT_LIBS}")
    list(APPEND XFT_LIB_DIR ${XFT_LIBRARY_DIRS} ${XFT_LIBDIR})
    #message("XFT_LIB_DIR: ${XFT_LIB_DIR}")
    list(APPEND XFT_INC_DIR ${XFT_INCLUDE_DIRS} ${XFT_INCLUDEDIR})
    #message("XFT_INC_DIR: ${XFT_INC_DIR}")
endif(XFT_FOUND)

if(WANT_SOUND)

    # Check for ALSA 1.0
    pkg_check_modules(ALSA REQUIRED alsa>=1.0)
    if(ALSA_FOUND)
        set(HAVE_ALSA TRUE)
        add_definitions(-DHAVE_ALSA)
        set(ALSA_LIBS ${ALSA_LIBRARIES})
        #message("ALSA_LIBS: ${ALSA_LIBS}")
        list(APPEND ALSA_LIB_DIR ${ALSA_LIBRARY_DIRS} ${ALSA_LIBDIR} )
        #message("ALSA_LIB_DIR: ${ALSA_LIB_DIR}")
        list(APPEND ALSA_INC_DIR ${ALSA_INCLUDE_DIRS} ${ALSA_INCLUDEDIR})
        #message("ALSA_INC_DIR: ${ALSA_INC_DIR}")
    else(ALSA_FOUND)
        message(FATAL_ERROR "Please install the required package. Aborting")
    endif(ALSA_FOUND)

    if(WANT_JACK)
        pkg_check_modules(JACK jack>=0.77)
        if(JACK_FOUND)
            add_definitions(-DHAVE_LIBJACK)
            set(HAVE_JACK TRUE)
            set(JACK_LIBS ${JACK_LIBRARIES})
            #message("JACK_LIBS: ${JACK_LIBS}")
            list(APPEND JACK_LIB_DIR ${JACK_LIBDIR} ${JACK_LIBRARY_DIRS})
            #message("JACK_LIB_DIR: ${JACK_LIB_DIR}")
            list(APPEND JACK_INC_DIR ${JACK_INCLUDEDIR} ${JACK_INCLUDE_DIRS})
            #message("JACK_INC_DIR: ${JACK_INC_DIR}")
        endif(JACK_FOUND)
    endif(WANT_JACK)

    if(WANT_DSSI)
        pkg_check_modules(DSSI dssi>=0.4)
        if(DSSI_FOUND)
            add_definitions(-DHAVE_DSSI)
            set(HAVE_DSSI TRUE)
            list(APPEND DSSI_INC_DIR ${DSSI_INCLUDE_DIRS} ${DSSI_INCLUDEDIR})
            #message("DSSI_INC_DIR: ${DSSI_INC_DIR}")
        endif(DSSI_FOUND)
    endif(WANT_DSSI)

    pkg_check_modules(LIBLO liblo>=0.7)
    if(LIBLO_FOUND)
        add_definitions(-DHAVE_LIBLO)
        set(HAVE_LIBLO TRUE)
        set(LIBLO_LIBS ${LIBLO_LIBRARIES})
        #message("LIBLO_LIBS: ${LIBLO_LIBS}")
        list(APPEND LIBLO_LIB_DIR ${LIBLO_LIBDIR} ${LIBLO_LIBRARY_DIRS})
        #message("LIBLO_LIB_DIR: ${LIBLO_LIB_DIR}")
        list(APPEND LIBLO_INC_DIR ${LIBLO_INCLUDEDIR} ${LIBLO_INCLUDE_DIRS})
        #message("LIBLO_INC_DIR: ${LIBLO_INC_DIR}")
    endif(LIBLO_FOUND)

    pkg_check_modules(LRDF lrdf>=0.3)
    if(LRDF_FOUND)
        set(HAVE_LIBLRDF TRUE)
        add_definitions(-DHAVE_LIBLRDF)
        set(LRDF_LIBS ${LRDF_LIBRARIES})
        #message("LRDF_LIBS: ${LRDF_LIBS}")
        list(APPEND LRDF_LIB_DIR ${LRDF_LIBDIR} ${LRDF_LIBRARY_DIRS})
        #message("LRDF_LIB_DIR: ${LRDF_LIB_DIR}")
        list(APPEND LRDF_INC_DIR ${LRDF_INCLUDEDIR} ${LRDF_INCLUDE_DIRS})
        #message("LRDF_INC_DIR: ${LRDF_INC_DIR}")
    endif(LRDF_FOUND)

    ##################################################################
    # - Try to find LADSPA header
    # Once done this will define:
    #
    #  LADSPA_FOUND - system has LADSPA
    #  LADSPA_INCLUDE_DIR - LADSPA header path
    if(LADSPA_INCLUDE_DIR)
       set(LADSPA_FIND_QUIETLY TRUE)
    endif(LADSPA_INCLUDE_DIR)
    find_path(LADSPA_INCLUDE_DIR "ladspa.h"
       /usr/include
       /usr/local/include
    )
    if(LADSPA_INCLUDE_DIR)
       set(LADSPA_FOUND TRUE)
    else(LADSPA_INCLUDE_DIR)
       set(LADSPA_FOUND FALSE)
       set(LADSPA_INCLUDE_DIR "")
    endif(LADSPA_INCLUDE_DIR)
    if(LADSPA_FOUND)
        if(NOT LADSPA_FIND_QUIETLY)
            message(STATUS "Found LADSPA: ${LADSPA_INCLUDE_DIR}")
        endif(NOT LADSPA_FIND_QUIETLY)
    else(LADSPA_FOUND)
        if(LADSPA_FIND_REQUIRED)
            message(FATAL_ERROR "Could not find LADSPA")
        endif(LADSPA_FIND_REQUIRED)
    endif(LADSPA_FOUND)
    mark_as_advanced(LADSPA_INCLUDE_DIR)
    ##################################################################

    if(LADSPA_FOUND)
        set(HAVE_LADSPA TRUE)
        add_definitions(-DHAVE_LADSPA)
        set(LADSPA_INC_DIR ${LADSPA_INCLUDE_DIR})
    endif(LADSPA_FOUND)

endif(WANT_SOUND)

pkg_check_modules(FFTW3F REQUIRED fftw3f>=3.0.0)
if(FFTW3F_FOUND)
    add_definitions(-DHAVE_FFTW3F)
    set(HAVE_FFTW3F TRUE)
    set(FFTW3F_LIBS ${FFTW3F_LIBRARIES})
    #message("FFTW3F_LIBS: ${FFTW3F_LIBS}")
    list(APPEND FFTW3F_LIB_DIR ${FFTW3F_LIBDIR} ${FFTW3F_LIBRARY_DIRS})
    #message("FFTW3F_LIB_DIR: ${FFTW3F_LIB_DIR}")
    list(APPEND FFTW3F_INC_DIR ${FFTW3F_INCLUDEDIR} ${FFTW3F_INCLUDE_DIRS})
    #message("FFTW3F_INC_DIR: ${FFTW3F_INC_DIR}")
else(FFTW3F_FOUND)
    message(FATAL_ERROR "Please install the required package. Aborting")
endif(FFTW3F_FOUND)

if(WANT_LIRC)
    find_package(LIRC QUIET)
    if(LIRC_FOUND)
        set(HAVE_LIRC TRUE)
        add_definitions(-DHAVE_LIRC)
        message(STATUS "Found LIRC (${LIRC_LIBRARY})")
        set(LIRC_LIBS ${LIRC_LIBRARY})
        set(LIRC_INC_DIR ${LIRC_INCLUDE_DIR})
        set(LIRC_LIB_DIR ${LIRC_LIBRARY_DIR})
        #message("LIRC_LIBS: ${LIRC_LIBS}")
        #message("LIRC_LIB_DIR: ${LIRC_LIB_DIR}")
        #message("LIRC_INC_DIR: ${LIRC_INC_DIR}")
    endif(LIRC_FOUND)
endif(WANT_LIRC)

# Check GCC for PCH support
set(USE_PCH FALSE)
if(WANT_PCH)
    find_package(PCHSupport)
    if(PCHSupport_FOUND)
        set(USE_PCH TRUE)
        add_definitions(-DUSE_PCH)
        message(STATUS "Enabling precompiled headers for GCC ${gcc_compiler_version}")
    endif(PCHSupport_FOUND)
endif(WANT_PCH)

# Check PTHREAD_MUTEX_RECURSIVE
include(CheckCSourceCompiles)
check_c_source_compiles(
    "#include <pthread.h>
     int main(int argc, char **argv) {
         pthread_mutexattr_t attr;
         pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
         return 0;
     }" PTHREAD_HAS_MUTEX_RECURSIVE)
if(PTHREAD_HAS_MUTEX_RECURSIVE)
    add_definitions(-DHAVE_PTHREAD_MUTEX_RECURSIVE)
endif(PTHREAD_HAS_MUTEX_RECURSIVE)
# End of PTHREAD_MUTEX_RECURSIVE Test

set(CMAKE_CXX_FLAGS_RELEASE         "-O2 -w -fexceptions -DNDEBUG -include tqt.h")
set(CMAKE_CXX_FLAGS_RELWITHDEBINFO  "-O2 -g -Wall -fexceptions -DDEBUG -include tqt.h")
set(CMAKE_CXX_FLAGS_DEBUG           "-O0 -g3 -Wall -fexceptions -DDEBUG -include tqt.h")

message(STATUS "Rosegarden ${PACKAGE_VERSION} will be built for install into ${CMAKE_INSTALL_PREFIX}")

if(WANT_DEBUG)
    if(WANT_FULLDBG)
        message(STATUS "Configured to compile including full debug information in the executables")
        set(CMAKE_BUILD_TYPE Debug CACHE STRING
            "Choose the type of build, options are: Debug Release RelWithDebInfo" FORCE)
    else(WANT_FULLDBG)
        message(STATUS "Configured to compile including debug information in the executables")
        set(CMAKE_BUILD_TYPE RelWithDebInfo CACHE STRING
            "Choose the type of build, options are: Debug Release RelWithDebInfo" FORCE)
    endif(WANT_FULLDBG)
else(WANT_DEBUG)
    message(STATUS "Configured to compile for release without debug information")
    set(CMAKE_BUILD_TYPE Release CACHE STRING
        "Choose the type of build, options are: Debug Release RelWithDebInfo" FORCE)
endif(WANT_DEBUG)
mark_as_advanced(CMAKE_BUILD_TYPE)

check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )
