/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef TEXT_COFF_H
#define TEXT_COFF_H

#include "coff_object.h"

namespace Coff
{

class TextObject : public Object
{
public:
  TextObject(const Device::Data *device, const PURL::Url &url);
  virtual bool parse(Log::Base &log);
  int lineForAddress(const PURL::Url &url, Address address) const;
  TQMap<PURL::Url, uint> sourceLinesForAddress(Address address) const; // url -> line
  TQValueVector<Address> addresses(const PURL::Url &url, uint line) const;
  const TQStringList &filenames() const;

  TQString disassembly() const;
  virtual Log::KeyList information() const;

private:
  mutable bool _initialized;
  mutable TQMap<Address, uint> _lines; // address -> line in disassembly listing
  mutable TQStringList _list;
  mutable TQStringList _filenames;

  uint nbLines(const TQString &filename) const;
  TQValueVector<const CodeLine *> findCodeLines(const TQString &filename, uint line) const;
  PURL::Url urlForFilename(const TQString &filename) const;
  void init() const;
  const Section *section(const CodeLine &cline) const;
};

} // namespace

#endif
