/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#include <tdeconfigbase.h>

class TDEConfigINIBackEnd;

class ProgramConfig : public TDEConfigBase
{
public:
    ProgramConfig(const TQString &fileName);
    virtual TQStringList groupList() const;
    virtual TQMap<TQString, TQString> entryMap(const TQString &group) const;
    virtual void reparseConfiguration();
    virtual KEntryMap internalEntryMap( const TQString& pGroup ) const;
    virtual KEntryMap internalEntryMap() const;
    virtual void putData(const KEntryKey &_key, const KEntry &_data, bool _checkGroup = true);
    virtual KEntry lookupData(const KEntryKey &_key) const;
    virtual bool internalHasGroup(const TQCString &group) const;

protected:
    /**
     * Contains all key,value entries, as well as some "special"
     * keys which indicate the start of a group of entries.
     *
     * These special keys will have the .key portion of their @ref KEntryKey
     * set to TQString::null.
     */
    KEntryMap m_entryMap;
    TQString m_fileName;
    // this is defined out-of-line
    struct MyBackend;
    MyBackend* m_iniBackend;
};
