/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef BRKPT_H
#define BRKPT_H

#include <tqlistview.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqlineedit.h>
#include <tqvaluevector.h>

class KDebugger;
class BreakpointItem;


class BreakpointTable : public TQWidget
{
    TQ_OBJECT
public:
    BreakpointTable(TQWidget* parent, const char* name);
    ~BreakpointTable();
    void setDebugger(KDebugger* deb) { m_debugger = deb; }

protected:
    KDebugger* m_debugger;
    TQLineEdit m_bpEdit;
    TQListView m_list;
    TQPushButton m_btAddBP;
    TQPushButton m_btAddWP;
    TQPushButton m_btRemove;
    TQPushButton m_btEnaDis;
    TQPushButton m_btViewCode;
    TQPushButton m_btConditional;
    TQHBoxLayout m_layout;
    TQVBoxLayout m_listandedit;
    TQVBoxLayout m_buttons;
    TQValueVector<TQPixmap> m_icons;

    void insertBreakpoint(int num, bool temp, bool enabled, TQString location,
			  TQString fileName = 0, int lineNo = -1,
			  int hits = 0, uint ignoreCount = 0,
			  TQString condition = TQString());
    void initListAndIcons();
    virtual bool eventFilter(TQObject* ob, TQEvent* ev);

    friend class BreakpointItem;
    
signals:
    /**
     * This signal is emitted when the user wants to go to the source code
     * where the current breakpoint is in.
     * 
     * @param file specifies the file; this is not necessarily a full path
     * name, and if it is relative, you won't know relative to what, you
     * can only guess.
     * @param lineNo specifies the line number (0-based!).
     * @param address specifies the exact address of the breakpoint.
     */
    void activateFileLine(const TQString& file, int lineNo, const DbgAddr& address);
public slots:
    virtual void addBP();
    virtual void addWP();
    virtual void removeBP();
    virtual void enadisBP();
    virtual void viewBP();
    virtual void conditionalBP();
    void updateUI();
    void updateBreakList();
};

#endif // BRKPT_H
