/*
    This file is part of Akregator.

    Copyright (C) 2004 Sashmit Bhaduri <smt@vfemail.net>
                  2005 Frank Osterfeld <frank.osterfeld at kdemail.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef PAGEVIEWER_H
#define PAGEVIEWER_H

#include "viewer.h"


class TDEAction;
class TDEToolBarPopupAction;
class TQString;

namespace Akregator
{
    
    // the back/forward navigation was taken from KDevelop. Kudos to the KDevelop team!
    class PageViewer : public Viewer
    {
        TQ_OBJECT
  
        public:
            PageViewer(TQWidget* parent, const char* name);
            virtual ~PageViewer();
            virtual bool openURL(const KURL &url);

        protected:

            class HistoryEntry;
            void addHistoryEntry(const KURL& url);
            void restoreHistoryEntry(const TQValueList<HistoryEntry>::Iterator& entry);
            void updateHistoryEntry();

        protected slots:

            void slotSetCaption(const TQString& cap);
            void slotBack();
            void slotForward();
            void slotReload();
            void slotStop();

            virtual void slotPaletteOrFontChanged();

            void slotStarted(TDEIO::Job *);
            void slotCompleted();
            void slotCancelled(const TQString &errMsg);
            void slotBackAboutToShow();
            void slotForwardAboutToShow();
            void slotPopupActivated( int id );
            virtual void slotPopupMenu(KXMLGUIClient*, const TQPoint&, const KURL&, const KParts::URLArgs&, KParts::BrowserExtension::PopupFlags, mode_t);
            
            void slotGlobalBookmarkArticle();
            
            virtual void slotOpenURLRequest(const KURL& url, const KParts::URLArgs& args);
            virtual void urlSelected(const TQString &url, int button, int state, const TQString &_target, KParts::URLArgs args);
            
        signals:
            void setTabIcon(const TQPixmap&);

        private:
            class PageViewerPrivate;
            PageViewerPrivate* d;
    };
}

#endif // PAGEVIEWER_H
