// This module implements the TQextScintillaLexerProperties class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <tqcolor.h>
#include <tqfont.h>
#include <tqsettings.h>

#include "tqextscintillalexerproperties.h"


// The ctor.
TQextScintillaLexerProperties::TQextScintillaLexerProperties(TQObject *parent,const char *name)
	: TQextScintillaLexer(parent,name), fold_compact(true)
{
}


// The dtor.
TQextScintillaLexerProperties::~TQextScintillaLexerProperties()
{
}


// Returns the language name.
const char *TQextScintillaLexerProperties::language() const
{
	return "Properties";
}


// Returns the lexer name.
const char *TQextScintillaLexerProperties::lexer() const
{
	return "props";
}


// Return the string of characters that comprise a word.
const char *TQextScintillaLexerProperties::wordCharacters() const
{
	return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-";
}


// Returns the foreground colour of the text for a style.
TQColor TQextScintillaLexerProperties::color(int style) const
{
	switch (style)
	{
	case Comment:
		return TQColor(0x00,0x7f,0x7f);

	case Section:
		return TQColor(0x7f,0x00,0x7f);

	case Assignment:
		return TQColor(0xb0,0x60,0x00);

	case DefaultValue:
		return TQColor(0x7f,0x7f,0x00);
	}

	return TQextScintillaLexer::color(style);
}


// Returns the end-of-line fill for a style.
bool TQextScintillaLexerProperties::eolFill(int style) const
{
	return (style == Section);
}


// Returns the font of the text for a style.
TQFont TQextScintillaLexerProperties::font(int style) const
{
	TQFont f;

	if (style == Comment)
#if defined(Q_OS_WIN)
		f = TQFont("Comic Sans MS",9);
#else
		f = TQFont("Bitstream Vera Serif",9);
#endif
	else
		f = TQextScintillaLexer::font(style);

	return f;
}


// Returns the user name of a style.
TQString TQextScintillaLexerProperties::description(int style) const
{
	switch (style)
	{
	case Default:
		return tr("Default");

	case Comment:
		return tr("Comment");

	case Section:
		return tr("Section");

	case Assignment:
		return tr("Assignment");

	case DefaultValue:
		return tr("Default value");
	}

	return TQString();
}


// Returns the background colour of the text for a style.
TQColor TQextScintillaLexerProperties::paper(int style) const
{
	if (style == Section)
		return TQColor(0xe0,0xf0,0xf0);

	return TQextScintillaLexer::paper(style);
}


// Refresh all properties.
void TQextScintillaLexerProperties::refreshProperties()
{
	setCompactProp();
}


// Read properties from the settings.
bool TQextScintillaLexerProperties::readProperties(TQSettings &qs,const TQString &prefix)
{
	bool rc = true;
	bool ok, flag;

	// Read the fold compact flag.
	flag = qs.readBoolEntry(prefix + "foldcompact",true,&ok);

	if (ok)
		fold_compact = flag;
	else
		rc = false;

	return rc;
}


// Write properties to the settings.
bool TQextScintillaLexerProperties::writeProperties(TQSettings &qs,const TQString &prefix) const
{
	bool rc = true;

	// Write the fold compact flag.
	if (!qs.writeEntry(prefix + "foldcompact",fold_compact))
		rc = false;

	return rc;
}


// Return true if folds are compact.
bool TQextScintillaLexerProperties::foldCompact() const
{
	return fold_compact;
}


// Set if folds are compact
void TQextScintillaLexerProperties::setFoldCompact(bool fold)
{
	fold_compact = fold;

	setCompactProp();
}


// Set the "fold.compact" property.
void TQextScintillaLexerProperties::setCompactProp()
{
	emit propertyChanged("fold.compact",(fold_compact ? "1" : "0"));
}

#include "tqextscintillalexerproperties.moc"
