//
// C++ Interface: malloryclient
//
// Description:
//
//
// Author: Remi Villatel <maxilys@tele2>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MALLORYCLIENT_H
#define MALLORYCLIENT_H

#include <kdecoration.h>
#include <kdecorationfactory.h>
#include <tqlayout.h>

#include "mallorybutton.h"
#include "enums.h"

class MalloryButton;

class MalloryClient : public KDecoration
{
TQ_OBJECT
public:
	MalloryClient(KDecorationBridge* bridge, KDecorationFactory* factory);
	~MalloryClient();

	virtual void init();
	virtual bool eventFilter(TQObject* o, TQEvent* e);

	virtual TQSize minimumSize() const;
	virtual void borders(int& left, int& right, int& top, int& bottom) const;

protected:
	virtual void desktopChange();
	virtual void activeChange();
	virtual void captionChange();
	virtual void maximizeChange();
	virtual void iconChange();
	virtual void shadeChange() {};

	virtual void paintEvent(TQPaintEvent *e);
	virtual void showEvent(TQShowEvent*);

	virtual void resize(const TQSize&);
	virtual void reset(unsigned long changed);

private:
	void addButtons(TQBoxLayout *layout, const TQString &buttons);
	void resizeEvent(TQResizeEvent *e);
	void mouseDoubleClickEvent(TQMouseEvent *e);
	Position mousePosition(const TQPoint &point) const;

	MalloryButton *m_button[ButtonTypeCount];
	TQSpacerItem *m_titleBar, *m_leftSpacer, *m_rightSpacer, *m_topSpacer, *m_bottomSpacer, *m_leftButtonSpacer, *m_leftButtonSpacer2, *m_rightButtonSpacer, *m_rightButtonSpacer2;

private slots:
	void maxButtonPressed();
	void menuButtonPressed();
};

#endif
