
#ifndef BAGHIRASIDEBAR_H
#define BAGHIRASIDEBAR_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <konqsidebarplugin.h>
#include <tdeconfig.h>

class LinkView;
class TDEListBox;
class TQListBoxItem;

class baghiraSidebar : public KonqSidebarPlugin
{
    TQ_OBJECT
    
public:
    /**
     * Construct a @ref KonqSidebarPlugin.
     *
     * @param inst The sidebar's kinstance class.
     * @param parent The sidebar internal button info class responsible for this plugin.
     * @param widgetParent The container which will contain the plugins widget.
     * @param desktopName The filename of the configuration file.
     * @param name A TQt object name for your plugin.
     **/
     baghiraSidebar(TDEInstance *inst,TQObject *parent, TQWidget *widgetParent, TQString &desktopName, const char* name=0);

    /** destructor */
    ~baghiraSidebar();
    
   virtual TQWidget *getWidget(){return scrollView;}
   virtual void *provides(const TQString &) {return 0;}

protected:
   LinkView *scrollView;
   virtual void handleURL(const KURL &url);

private slots:
   void callURL(TQListBoxItem *);

signals:
   void openURLRequest(const KURL &url, const KParts::URLArgs &args);

};

#endif
