/***************************************************************************
                          dirtydlg.cpp  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2002, 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

//qt includes
#include <tqevent.h>
#include <tqlabel.h>
#include <tqradiobutton.h>
#include <tqpushbutton.h>

//kde includes
#include <kdialogbase.h>
#include <tdelocale.h>
#include <tdeprocess.h>
#include <tdeio/job.h>
#include <tdeio/jobclasses.h>
#include <tdeio/netaccess.h>
#include <tdefileitem.h>

//app includes
#include "dirtydialog.h"
#include "dirtydlg.h"
#include "resource.h"
#include "qextfileinfo.h"

DirtyDlg::DirtyDlg(const TQString& srcName, const TQString& destName, bool createBackup, TQWidget *parent, const char *name ) : KDialogBase(parent, name, true, i18n("File Changed"), KDialogBase::Ok)
{
 m_src.setPath(srcName);
 m_dest.setPath(destName);
 m_busy = false;
 m_createBackup = createBackup;
 m_mainWidget = new DirtyDialog(this);
 m_mainWidget->textLabel->setText(i18n("<qt>The file <b>%1</b> was changed outside of the Quanta editor.</qt>").arg(srcName));
 setMainWidget(m_mainWidget);
}

DirtyDlg::~DirtyDlg(){
}
/** No descriptions */
void DirtyDlg::slotOk()
{
 if (m_mainWidget->buttonCompare->isChecked())
 {
   m_busy = true;
   TDEProcess *proc = new TDEProcess();
   *proc << "kompare" << m_src.path() << m_dest.path();
   proc->start();
   connect(proc, TQ_SIGNAL(processExited(TDEProcess*)),TQ_SLOT(slotCompareDone(TDEProcess*)));
   enableButton(KDialogBase::Ok, false);
   enableButton(KDialogBase::Cancel, false);
 } else
 if (m_mainWidget->buttonLoad->isChecked())
 {
    accept();
 } else
 {
    reject();
 }
}

/** No descriptions */
void DirtyDlg::slotCompareDone(TDEProcess* proc)
{
 delete proc;

 if (m_createBackup)
 {
   KURL backupURL = m_src;
   backupURL.setPath(backupURL.path()+".backup");
   QExtFileInfo::copy(m_src, backupURL, -1, true, false, this);
 }

 TDEIO::UDSEntry entry;
 TDEIO::NetAccess::stat(m_src, entry, this);
 KFileItem item(entry, m_src, false, true);
 m_permissions = item.permissions();
 //TODO: Replace with TDEIO::NetAccess::file_move, when KDE 3.1 support
 //is dropped
 TDEIO::FileCopyJob *job = TDEIO::file_move(m_dest, m_src, m_permissions, true, false,false );
 connect( job, TQ_SIGNAL(result( TDEIO::Job *)),
                 TQ_SLOT  (slotResult( TDEIO::Job *)));
}


/** No descriptions */
void DirtyDlg::slotResult(TDEIO::Job *)
{
 m_busy = false;
 accept();
}

/** No descriptions */
void DirtyDlg::closeEvent(TQCloseEvent* ev)
{
  if (m_busy)
    ev->ignore();
  else
    ev->accept();
}

#include "dirtydlg.moc"
