/***************************************************************************
 *   Copyright (C) 2005 by Rajko Albrecht                                  *
 *   rajko.albrecht@tecways.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include <tdeuniqueapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <dcopclient.h>
#include "tdesvnd_dcop.h"

static const char description[] =
    I18N_NOOP("Tdesvn DCOP service");

static const char version[] = "0.1";

static TDECmdLineOptions options[] =
{
    TDECmdLineLastOption
};

int main (int argc, char *argv[])
{
    TDELocale::setMainCatalogue("tdesvn");
    TDEAboutData aboutdata("tdesvnd", I18N_NOOP("TDE"),
                version, description,
                TDEAboutData::License_GPL, "(C) %{YEAR}, Rajko Albrecht");
    aboutdata.addAuthor("Rajko Albrecht",I18N_NOOP("Developer"),"rajko.albrecht@tecways.com");

    TDECmdLineArgs::init( argc, argv, &aboutdata );
    TDECmdLineArgs::addCmdLineOptions( options );
    TDEUniqueApplication::addCmdLineOptions();

    if (!TDEUniqueApplication::start())
    {
        kdDebug() << "tdesvnd is already running!" << endl;
        return (0);
    }

    TDEUniqueApplication app;
    kdDebug() << "starting tdesvnd_dcop " << endl;
    // This app is started automatically, no need for session management
    app.disableSessionManagement();
    tdesvnd_dcop *service = new tdesvnd_dcop;
    kdDebug() << "starting tdesvnd_dcop " << endl;
    return app.exec();

}
