/*
    cwbugdetails.h  -  Details of a bug report
    
    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KBBMAINWINDOW_CWBUGDETAILS_H
#define KBBMAINWINDOW_CWBUGDETAILS_H

#include "bug.h"
#include "bugdetails.h"

#include <tqwidget.h>

#include <tdeparts/browserextension.h>

class TDEHTMLPart;

namespace KBugBusterMainWindow
{

/**
 * @author Martijn Klingens
 */
class CWBugDetails : public TQWidget
{
    TQ_OBJECT
  

  public:
    CWBugDetails( TQWidget* parent = 0, const char* name = 0 );
    ~CWBugDetails();

    void setBug( const Bug &, const BugDetails & );

    TQString source() const;
    TQString selectedText() const;

  private slots:
    void handleOpenURLRequest( const KURL &url, const KParts::URLArgs & );

  private:
    TQString textBugDetailsAttribute( const TQString &value,
                                     const TQString &name );

    TDEHTMLPart *m_bugDesc;

    TQString mSource;
};
 
}   // namespace

#endif
