/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef FILTERSELECTIONWIDGET_H
#define FILTERSELECTIONWIDGET_H

#include <tqhbox.h>

class KComboBox;

/**
  A simple widget which consists of a label and a combo box in a
  horizontal line. The combo box allows the user to select the active
  filter.
 */
class FilterSelectionWidget : public TQHBox
{
  TQ_OBJECT
  

  public:
    FilterSelectionWidget( TQWidget *parent, const char *name = 0 );
    ~FilterSelectionWidget();

    void setItems( const TQStringList &names );

    int currentItem() const;
    void setCurrentItem( int index );

  signals:
    void filterActivated( int );

  private:
    KComboBox *mFilterCombo;
};

#endif
