/***************************************************************************
                          kcontrolheader.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi@asyris.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcontrolheader.h"
#include "kcontrolheader.moc"

#include <tdelocale.h>
#include <tdestandarddirs.h>
#include <tdesimpleconfig.h>
#include <klineedit.h>
#include <kcombobox.h>

#include <tqlayout.h>
#include <tqlabel.h>

KControlHeader::KControlHeader(FileRead *keducaFile, TQWidget *parent, const char *name ) : KDialogBase(Swallow, i18n("Document Information"), Ok|Cancel, Ok, parent, name, true, true)
{
    _keducaFile = keducaFile;
    init();
    configRead();
}

KControlHeader::~KControlHeader(){}

/** Init graphical interface */
void KControlHeader::init()
{
    TQWidget *mainView = new TQWidget(this);

    TQVBoxLayout *Form2Layout = new TQVBoxLayout( mainView );
    Form2Layout->setSpacing( 6 );
    Form2Layout->setMargin( 0 );

    TQFrame *Frame16 = new TQFrame( mainView, "Frame16" );
    Frame16->setMinimumSize( TQSize( 0, 50 ) );
    Frame16->setMaximumSize( TQSize( 32767, 50 ) );
    Frame16->setFrameShape( TQFrame::Box );
    Frame16->setFrameShadow( TQFrame::Plain );
    Frame16->setPalette( TQPalette( TQColor(255, 255, 255) ) );
    TQHBoxLayout *Frame16Layout = new TQHBoxLayout( Frame16 );
    Frame16Layout->setSpacing( 6 );
    Frame16Layout->setMargin( 1 );

    TQFrame *Frame17 = new TQFrame( Frame16, "Frame17" );
    Frame17->setMinimumSize( TQSize( 125, 0 ) );
    Frame17->setMaximumSize( TQSize( 125, 32767 ) );
    Frame17->setFrameShape( TQFrame::NoFrame );
    Frame17->setFrameShadow( TQFrame::Raised );
    Frame17->setBackgroundPixmap( TQPixmap(locate("appdata","pics/bk_frame.png") ) );
    TQVBoxLayout *Frame17Layout = new TQVBoxLayout( Frame17 );
    Frame17Layout->setSpacing( 6 );
    Frame17Layout->setMargin( 11 );

    TQLabel *TextLabel1 = new TQLabel( Frame17, "TextLabel1" );
    TextLabel1->setText( "<b style=\"text-decoration:underline;\">"+i18n("Information")+"</b>"  );
    TextLabel1->setBackgroundPixmap( TQPixmap(locate("appdata","pics/bk_frame.png") ) );
    Frame17Layout->addWidget( TextLabel1 );
    Frame16Layout->addWidget( Frame17 );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    Frame16Layout->addItem( spacer );

    TQLabel *TextLabel2 = new TQLabel( Frame16, "TextLabel2" );
    TextLabel2->setText( i18n( "Description and rules of the project." ) );
    TextLabel2->setPalette( TQPalette( TQColor(255, 255, 255) ) );
    Frame16Layout->addWidget( TextLabel2 );
    Form2Layout->addWidget( Frame16 );

    TQGroupBox *GroupBox7 = new TQGroupBox( mainView, "GroupBox7" );
    GroupBox7->setTitle( i18n( "Description" ) );
    GroupBox7->setColumnLayout(0, TQt::Vertical );
    GroupBox7->layout()->setSpacing( 0 );
    GroupBox7->layout()->setMargin( 0 );
    TQVBoxLayout *GroupBox7Layout = new TQVBoxLayout( GroupBox7->layout() );
    GroupBox7Layout->setAlignment( TQt::AlignTop );
    GroupBox7Layout->setSpacing( 6 );
    GroupBox7Layout->setMargin( 11 );

    TQGridLayout *Layout13 = new TQGridLayout;
    Layout13->setSpacing( 6 );
    Layout13->setMargin( 0 );

    TQLabel *TextLabel10 = new TQLabel( GroupBox7, "TextLabel10" );
    TextLabel10->setText( i18n( "Type:" ));
    TextLabel10->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );

    Layout13->addWidget( TextLabel10, 2, 0 );

    TQHBoxLayout *Layout12 = new TQHBoxLayout;
    Layout12->setSpacing( 6 );
    Layout12->setMargin( 0 );

    _headerType = new KComboBox( false, GroupBox7, "_headerType" );
    Layout12->addWidget( _headerType );

    TQLabel *TextLabel11 = new TQLabel( GroupBox7, "TextLabel11" );
    TextLabel11->setText( i18n( "Level:" ));
    TextLabel11->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );
    Layout12->addWidget( TextLabel11 );

    _headerLevel = new KComboBox( false, GroupBox7, "_headerLevel" );
    Layout12->addWidget( _headerLevel );
    Layout13->addLayout( Layout12, 2, 1 );

    TQLabel *TextLabel12 = new TQLabel( GroupBox7, "TextLabel12" );
    TextLabel12->setText( i18n( "Language:" ));
    TextLabel12->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );
    Layout13->addWidget( TextLabel12, 3, 0 );

    _headerLang = new KLanguageCombo( GroupBox7, "_headerLang" );
    loadCountryList( _headerLang );
    Layout13->addWidget( _headerLang, 3, 1 );

    TQLabel *TextLabel9 = new TQLabel( GroupBox7, "TextLabel9" );
    TextLabel9->setText( i18n( "Category:" ));
    TextLabel9->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );

    Layout13->addWidget( TextLabel9, 1, 0 );

    _headerCategory = new KComboBox( true, GroupBox7, "_headerCategory" );
    Layout13->addWidget( _headerCategory, 1, 1 );

    _headerTitle = new TQLineEdit( GroupBox7, "_headerTitle" );
    Layout13->addWidget( _headerTitle, 0, 1 );

    TQLabel *TextLabel8 = new TQLabel( GroupBox7, "TextLabel8" );
    TextLabel8->setText( i18n( "Title:" ));
    TextLabel8->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );

    Layout13->addWidget( TextLabel8, 0, 0 );
    GroupBox7Layout->addLayout( Layout13 );
    Form2Layout->addWidget( GroupBox7 );

    TQGroupBox *GroupBox8 = new TQGroupBox( mainView, "GroupBox8" );
    GroupBox8->setTitle( i18n( "Picture" ) );
    GroupBox8->setColumnLayout(0, TQt::Vertical );
    GroupBox8->layout()->setSpacing( 0 );
    GroupBox8->layout()->setMargin( 0 );
    TQHBoxLayout *GroupBox8Layout = new TQHBoxLayout( GroupBox8->layout() );
    GroupBox8Layout->setAlignment( TQt::AlignTop );
    GroupBox8Layout->setSpacing( 6 );
    GroupBox8Layout->setMargin( 11 );

    TQLabel *TextLabel13 = new TQLabel( GroupBox8, "TextLabel13" );
    TextLabel13->setText( i18n( "Default picture:" ));
    GroupBox8Layout->addWidget( TextLabel13 );

    _headerPicture = new KURLRequester( GroupBox8, "_headerPicture" );
    GroupBox8Layout->addWidget( _headerPicture );
    Form2Layout->addWidget( GroupBox8 );

    TQGroupBox *GroupBox6 = new TQGroupBox( mainView, "GroupBox6" );
    GroupBox6->setTitle( i18n( "Author" ) );
    GroupBox6->setColumnLayout(0, TQt::Vertical );
    GroupBox6->layout()->setSpacing( 0 );
    GroupBox6->layout()->setMargin( 0 );
    TQGridLayout *GroupBox6Layout = new TQGridLayout( GroupBox6->layout() );
    GroupBox6Layout->setAlignment( TQt::AlignTop );
    GroupBox6Layout->setSpacing( 6 );
    GroupBox6Layout->setMargin( 11 );

    _headerName = new TQLineEdit( GroupBox6, "_headerName" );

    GroupBox6Layout->addWidget( _headerName, 0, 1 );

    _headerEmail = new TQLineEdit( GroupBox6, "_headerEmail" );

    GroupBox6Layout->addWidget( _headerEmail, 1, 1 );

    TQLabel *TextLabel7 = new TQLabel( GroupBox6, "TextLabel7" );
    TextLabel7->setText( i18n( "Web page:" ));
    TextLabel7->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );

    GroupBox6Layout->addWidget( TextLabel7, 2, 0 );

    TQLabel *TextLabel6 = new TQLabel( GroupBox6, "TextLabel6" );
    TextLabel6->setText( i18n( "Email:" ));
    TextLabel6->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );

    GroupBox6Layout->addWidget( TextLabel6, 1, 0 );

    TQLabel *TextLabel5 = new TQLabel( GroupBox6, "TextLabel5" );
    TextLabel5->setText( i18n( "Name:" ));
    TextLabel5->setAlignment( int( TQLabel::AlignVCenter | TQLabel::AlignRight ) );

    GroupBox6Layout->addWidget( TextLabel5, 0, 0 );

    _headerWWW = new TQLineEdit( GroupBox6, "_headerWWW" );

    GroupBox6Layout->addWidget( _headerWWW, 2, 1 );
    Form2Layout->addWidget( GroupBox6 );

    // tab order
    setTabOrder( _headerTitle, _headerCategory );
    setTabOrder( _headerCategory, _headerType );
    setTabOrder( _headerType, _headerLevel );
    setTabOrder( _headerLevel, _headerLang );
    setTabOrder( _headerLang, _headerPicture->lineEdit() );
    setTabOrder( _headerPicture->lineEdit(), _headerPicture->comboBox() );
    setTabOrder( _headerPicture->comboBox(), _headerName );
    setTabOrder( _headerName, _headerEmail );
    setTabOrder( _headerEmail, _headerWWW );

    // set a sensible focus
    _headerTitle->setFocus();

    setMainWidget(mainView);
}

/** Insert header */
void KControlHeader::insertHeader()
{
    TQStringList tmpResult = _defaultCategories.grep( _headerCategory->currentText() );
    if( tmpResult.count() == 0 )
    {
        TDEConfig *appconfig = TDEGlobal::config();
        _defaultCategories.append( _headerCategory->currentText() );
        appconfig->setGroup("General");
        appconfig->writeEntry( "Categories", _defaultCategories);
        appconfig->sync();
    }
    _keducaFile->setHeader( "category", 	_headerCategory->currentText() );
    _keducaFile->setHeader( "title",			_headerTitle->text() );
    _keducaFile->setHeader( "image",			_headerPicture->url() );
    _keducaFile->setHeader( "type", 			TQString().setNum( _headerType->currentItem() + 1 ) );
    _keducaFile->setHeader( "level",			TQString().setNum( _headerLevel->currentItem() + 1 ) );
    _keducaFile->setHeader( "language",	_headerLang->currentTag() );
    _keducaFile->setHeader( "name",	 		_headerName->text() );
    _keducaFile->setHeader( "email", 		_headerEmail->text() );
    _keducaFile->setHeader( "www", 			_headerWWW->text() );
}

/** Load country list */
void KControlHeader::loadCountryList(KLanguageCombo *combo)
{
    TQString sub = TQString::fromLatin1("l10n/");

    // clear the list
    combo->clear();

    TQStringList regionlist = TDEGlobal::dirs()->findAllResources("locale", sub + TQString::fromLatin1("*.desktop"));
    regionlist.sort();

    for ( TQStringList::ConstIterator it = regionlist.begin();
          it != regionlist.end();
          ++it )
    {
        TQString tag = *it;
        int index;

        index = tag.findRev('/');
        if (index != -1) tag = tag.mid(index + 1);

        index = tag.findRev('.');
        if (index != -1) tag.truncate(index);

        TDESimpleConfig entry(*it);
        entry.setGroup(TQString::fromLatin1("KCM Locale"));
        TQString name = entry.readEntry(TQString::fromLatin1("Name"));

        combo->insertSubmenu( name, '-' + tag, sub );
    }

    // add all languages to the list
    TQStringList countrylist = TDEGlobal::dirs()->findAllResources("locale",  sub + TQString::fromLatin1("*/entry.desktop"));
    countrylist.sort();

    for ( TQStringList::ConstIterator it = countrylist.begin();
          it != countrylist.end(); ++it )
    {
        TDESimpleConfig entry(*it);
        entry.setGroup(TQString::fromLatin1("KCM Locale"));
        TQString name = entry.readEntry(TQString::fromLatin1("Name"));
        TQString submenu = '-' + entry.readEntry(TQString::fromLatin1("Region"));

        TQString tag = *it;
        int index = tag.findRev('/');
        tag.truncate(index);
        index = tag.findRev('/');
        tag = tag.mid(index+1);
        combo->insertLanguage(tag, name, sub, submenu);
    }
}

/** Ok push */
void KControlHeader::slotOk()
{
    insertHeader();
    configWrite();
    accept();
}

/** Read settings */
void KControlHeader::configRead()
{
    TDEConfig *config = new TDEConfig("emaildefaults");
    TDEConfig *appconfig = TDEGlobal::config();

    config->setGroup("UserInfo");

    if( _keducaFile->getHeader( "name" ).isEmpty() )
        _headerName->setText(config->readEntry("FullName", TQString() ));
    else
        _headerName->setText( _keducaFile->getHeader("name") );

    if( _keducaFile->getHeader( "email" ).isEmpty() )
        _headerEmail->setText(config->readEntry("EmailAddress", TQString() ));
    else
        _headerEmail->setText( _keducaFile->getHeader("email") );

    _headerWWW->setText( _keducaFile->getHeader("www") );

    if( !_keducaFile->getHeader("language").isEmpty() )
    {
        _headerLang->setCurrentItem( _keducaFile->getHeader("language") );
    }
    else
    {
        config->setGroup("Locale");
        _headerLang->setCurrentItem( config->readEntry("Country") );
    }

    appconfig->setGroup("General");
    _defaultCategories = appconfig->readListEntry("Categories");
    if( _defaultCategories.count() == 0 )
    {
        _defaultCategories.append(i18n("Computers"));
    }
    _defaultCategories.sort();
    _headerCategory->insertStringList( _defaultCategories );
    if( !_keducaFile->getHeader( "category" ).isEmpty() ) _headerCategory->setEditText( _keducaFile->getHeader("category") );

    _headerType->insertItem( i18n("Test") );
    _headerType->insertItem( i18n("Test with Question Points") );
    _headerType->insertItem( i18n("Test with Answers Points") );
    _headerType->insertItem( i18n("Slidershow") );
    _headerType->insertItem( i18n("Exam") );
    _headerType->insertItem( i18n("Psychotechnic Test") );
    if( TQString(_keducaFile->getHeader("type")).toInt() > 0 ) _headerType->setCurrentItem( TQString(_keducaFile->getHeader("type")).toInt() -1 );

    _headerLevel->insertItem( i18n("Easy") );
    _headerLevel->insertItem( i18n("Normal") );
    _headerLevel->insertItem( i18n("Expert") );
    _headerLevel->insertItem( i18n("Supreme") );
    if( TQString(_keducaFile->getHeader("level")).toInt() >0 ) _headerLevel->setCurrentItem( TQString(_keducaFile->getHeader("level")).toInt() -1 );

    _headerPicture->setURL( _keducaFile->getHeader("image") );
    _headerTitle->setText( _keducaFile->getHeader("title") );

    appconfig->setGroup("kcontrolheader");
    TQSize *defaultSize = new TQSize(500,400);
    resize( appconfig->readSizeEntry("Geometry", defaultSize ) );
    delete config;
}

/** Write settings */
void KControlHeader::configWrite()
{
    TDEConfig *config = TDEGlobal::config();
    config->setGroup("kcontrolheader");
    config->writeEntry("Geometry", size() );
    config->sync();
}
