/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "NotationEraser.h"
#include <tdeapplication.h>

#include <tdelocale.h>
#include "document/ConfigGroups.h"
#include "base/ViewElement.h"
#include "commands/notation/EraseEventCommand.h"
#include "gui/general/EditTool.h"
#include "NotationTool.h"
#include "NotationView.h"
#include "NotePixmapFactory.h"
#include <tdeaction.h>
#include <tdeconfig.h>
#include <tqiconset.h>
#include <tqstring.h>


namespace Rosegarden
{

NotationEraser::NotationEraser(NotationView* view)
        : NotationTool("NotationEraser", view),
        m_collapseRest(false)
{
    TDEConfig *config = tdeApp->config();
    config->setGroup(NotationViewConfigGroup);
    m_collapseRest = config->readBoolEntry("collapse", false);

    new TDEToggleAction(i18n("Collapse rests after erase"), 0, this,
                      TQ_SLOT(slotToggleRestCollapse()), actionCollection(),
                      "toggle_rest_collapse");

    TQIconSet icon
    (NotePixmapFactory::toTQPixmap(NotePixmapFactory::
                                  makeToolbarPixmap("crotchet")));
    new TDEAction(i18n("Switch to Insert Tool"), icon, 0, this,
                TQ_SLOT(slotInsertSelected()), actionCollection(),
                "insert");

    icon = TQIconSet(NotePixmapFactory::toTQPixmap(NotePixmapFactory::
                    makeToolbarPixmap("select")));
    new TDEAction(i18n("Switch to Select Tool"), icon, 0, this,
                TQ_SLOT(slotSelectSelected()), actionCollection(),
                "select");

    createMenu("notationeraser.rc");
}

void NotationEraser::ready()
{
    m_nParentView->setCanvasCursor(TQt::pointingHandCursor);
    m_nParentView->setHeightTracking(false);
}

void NotationEraser::handleLeftButtonPress(timeT,
        int,
        int staffNo,
        TQMouseEvent*,
        ViewElement* element)
{
    if (!element || staffNo < 0)
        return ;

    EraseEventCommand *command =
        new EraseEventCommand(m_nParentView->getStaff(staffNo)->getSegment(),
                              element->event(),
                              m_collapseRest);

    m_nParentView->addCommandToHistory(command);
}

void NotationEraser::slotToggleRestCollapse()
{
    m_collapseRest = !m_collapseRest;
}

void NotationEraser::slotInsertSelected()
{
    m_nParentView->slotLastNoteAction();
}

void NotationEraser::slotSelectSelected()
{
    m_parentView->actionCollection()->action("select")->activate();
}

const TQString NotationEraser::ToolName   = "notationeraser";

}
#include "NotationEraser.moc"
