/***************************************************************************
                          kshowmaildock.cpp  -  description
                             -------------------
    begin                : Wed Jan 3 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqpixmap.h>
#include <tqpainter.h>
#include <tqtooltip.h>

#include <tdepopupmenu.h>
#include <tdestandarddirs.h>
#include <tdeglobalsettings.h>
#include <tdelocale.h>
#include <kdebug.h>

#include "kshowmail.h"
#include "kshowmaildock.h"

KShowMailDock::KShowMailDock(TQWidget* parent, TDEAction *actionRefresh )
: KSystemTray (parent, 0),
      m_background (TQPixmap(::locate ("data", "kshowmail/pics/kshowmail24.png")))
{
//  kdDebug () << "KShowMailDock::KShowMailDock" << endl;
  drawText ("?", TQt::red);
  TQToolTip::add (this, i18n("KShowmail: a powerful pop3 email checker"));

  show();

  actionRefresh->plug( contextMenu() );
  //((KShowMailApp*)parent)->m_actionRefresh->plug (contextMenu());
  connect (contextMenu(),TQ_SIGNAL(activated(int)),this, TQ_SIGNAL(sigActivated(int)));
  connect (contextMenu(),TQ_SIGNAL(highlighted(int)),this, TQ_SIGNAL(sigHighlighted(int)));
}

void KShowMailDock::drawText (const TQString str, const TQColor& color)
{
  setPixmap (m_background);
  TQPixmap* pix = pixmap ();
   if (pix && !pix->isNull ())
  {
    TQPainter p (pix);
//     p.setFont (TDEGlobalSettings::toolBarFont());
     p.setFont (TDEGlobalSettings::windowTitleFont());
    p.setPen (color);
     p.drawText  (0,0,24,24,TQPainter::AlignCenter,str,str.length());
  }
  else
    kdError () << "No pixmap for traybar !" << endl;
}

void KShowMailDock::drawNumber (int n, const TQColor& color)
{
  setPixmap (m_background);
  TQPixmap* pix = pixmap ();
   if (pix && !pix->isNull ())
  {
    TQString num (TQString::number(n));
    TQPainter p (pix);
     p.setFont (TDEGlobalSettings::toolBarFont());
    p.setPen (color);
     p.drawText  (0,0,24,24,TQPainter::AlignCenter,num,num.length());
  }
  else
    kdError () << "No pixmap for traybar !" << endl;
}

void KShowMailDock::clear ()
{
  setPixmap (m_background);
}

#include "kshowmaildock.moc"
