//
// C++ Implementation: headerfilter
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "headerfilter.h"

HeaderFilter::HeaderFilter()
{
  //get the application config object
  config = tdeApp->config();

  //the filter list shall delete all filters if it will be deleted itself
  filters.setAutoDelete( true );

  //load settings
  load();
}


HeaderFilter::~HeaderFilter()
{
}

FilterAction_Type HeaderFilter::check( TQString from, TQString to, uint size, TQString subject, TQString header, TQString account, TQString& mailboxName ) const
{
  //return PASS, if filter is not active
  if( !active )
    return FActPass;
  
  //check for matching with blacklist or whitelist
  FilterAction_Type action = senderlist.check( from );
  if( action != FActNone ) return action;

  //check for matching with filters
  TQPtrListIterator<FilterItem> it( filters );
  FilterItem* filter;
  while( ( filter = it.current() ) != NULL )
  {
    ++it;
    action = filter->check( from, to, size, subject, header, account, mailboxName );

    if( action != FActNone ) return action;
  }

  //no matching; return default action
  if( defaultAction == FActMove )
  {
    mailboxName.remove( 0, mailboxName.length() );
    mailboxName.append( mailbox );
  }
  return defaultAction;

}

void HeaderFilter::load( )
{
  //order sender list to load its settings
  senderlist.load();

  //set group
  config->setGroup( CONFIG_GROUP_FILTER );

  //get filter active state
  active = config->readBoolEntry( CONFIG_ENTRY_FILTER_ACTIVE, DEFAULT_FILTER_ACTIVE );

  //get number of filter items
  numberFilterItems = config->readNumEntry( CONFIG_ENTRY_FILTER_NUMBER_OF_FILTERS, 0 );

  //get default action
  switch( config->readNumEntry( CONFIG_ENTRY_FILTER_OTHERS_ACTION, DEFAULT_FILTER_OTHERS_ACTION ) )
  {
    case CONFIG_VALUE_FILTER_OTHERS_ACTION_PASS       : defaultAction = FActPass; break;
    case CONFIG_VALUE_FILTER_OTHERS_ACTION_DELETE     : defaultAction = FActDelete; break;
    case CONFIG_VALUE_FILTER_OTHERS_ACTION_MARK       : defaultAction = FActMark; break;
    case CONFIG_VALUE_FILTER_OTHERS_ACTION_MOVE       : defaultAction = FActMove; break;
    case CONFIG_VALUE_FILTER_OTHERS_ACTION_IGNORE     : defaultAction = FActIgnore; break;
    case CONFIG_VALUE_FILTER_OTHERS_ACTION_SPAMCHECK  : defaultAction = FActSpamcheck; break;
    default                                           : kdError() << "Header Filter: Unknown default filter action. Set PASS." << endl;
                                                        defaultAction = FActPass;
                                                        break;
  }

  //get mailbox name if default action is MOVE
  if( defaultAction == FActMove )
    mailbox = config->readEntry( CONFIG_ENTRY_FILTER_OTHERS_MAILBOX, DEFAULT_FILTER_ACTION_MOVE_MAILBOX );

  //now we get the filters
  //first clear the list
  filters.clear();

  for( uint filterNr = 1; filterNr <= numberFilterItems; filterNr++ )
  {
    filters.append( new FilterItem( filterNr ) ); //a new created filter item loads its settings itself
  }
}

void HeaderFilter::print( )
{
  kdDebug() << "Header Filter Settings:" << endl;
  kdDebug() << "-----------------------" << endl;

  //print active state
  if( active )
    kdDebug() << "Header filter is active." << endl;
  else
    kdDebug() << "Header filter is not active." << endl;

  //print settings of black and white list
  senderlist.print();

  //print filters
  kdDebug() << endl;
  kdDebug() << "Number of filters: " << numberFilterItems << endl << endl;

  TQPtrListIterator<FilterItem> it( filters );
  FilterItem* filter;
  while( ( filter = it.current() ) != NULL )
  {
    ++it;
    filter->print();
    kdDebug() << endl;
  }

  //print default action for not matched mails
  switch( defaultAction )
  {
    case FActPass       : kdDebug() << "Default action for other mails: PASS" << endl; break;
    case FActDelete     : kdDebug() << "Default action for other mails: DELETE" << endl; break;
    case FActMark       : kdDebug() << "Default action for other mails: MARK" << endl; break;
    case FActIgnore     : kdDebug() << "Default action for other mails: IGNORE" << endl;
    case FActMove       : kdDebug() << "Default action for other mails: MOVE to " << mailbox << endl; break;
    case FActSpamcheck  : kdDebug() << "Default action for other mails: SPAMCHECK" << endl; break;
    default             : kdDebug() << "Unknown default action for other mails" << endl; break;
  }


}

bool HeaderFilter::isActive()
{
  return active;
}


