/* This file is part of the KDE project
   Copyright (C) 2003 Peter Simonsson <psn@linux.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KIVIOTEXTFORMATDLG_H
#define KIVIOTEXTFORMATDLG_H

#include <kdialogbase.h>

class KivioView;
class TDEFontChooser;
class KColorButton;
class TQButtonGroup;
class TQLabel;
class TQFont;
class TQColor;

class KivioTextFormatDlg : public KDialogBase
{
  TQ_OBJECT
  
  public:
    KivioTextFormatDlg(KivioView* parent, const char* name = 0);

    int valign();
    int halign();
    TQFont font();
    TQColor textColor();

  public slots:
    void setVAlign(int i);
    void setHAlign(int i);
    void setFont(TQFont f);
    void setTextColor(TQColor c);

  protected:
    void initFontTab();
    void initPositionTab();

  protected slots:
    void updateVAlign(int i);
    void updateHAlign(int i);
    void slotDefault();

  protected:
    TDEFontChooser* m_fontChooser;
    KColorButton* m_textCBtn;
    TQButtonGroup* m_halignBGrp;
    TQButtonGroup* m_valignBGrp;
    TQLabel* m_preview;
    int m_valign;
    int m_halign;
};

#endif
