/**
 * $Id: kchart_factory.h 508787 2006-02-12 18:28:12Z ingwa $
 *
 * Kalle Dalheimer <kalle@kde.org>
 */

#ifndef KCHART_FACTORY_H
#define KCHART_FACTORY_H


#include <KoFactory.h>


class TDEInstance;
class TDEAboutData;

namespace KChart
{

class KChartFactory : public KoFactory
{
    TQ_OBJECT
  
public:
    KChartFactory( TQObject* parent = 0, const char* name = 0 );
    virtual ~KChartFactory();

    virtual KParts::Part  *createPartObject( TQWidget* = 0, 
					     const char * = 0,
					     TQObject* parent = 0,
					     const char* name = 0,
					     const char* classname = "KoDocument",
					     const TQStringList &args = TQStringList() );

    static TDEInstance* global();

    // _Creates_ a TDEAboutData but doesn't keep ownership
    static TDEAboutData* aboutData();

private:
    static TDEInstance* s_global;
    static TDEAboutData *s_aboutData;
};

}  //namespace KChart

#endif
