/***************************************************************************
                          console.h  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONSOLE_H
#define CONSOLE_H

/* TQt */
#include <tqstringlist.h>
#include <tqvbox.h>
#include <tqlayout.h>
/* Local */
#include "definitions.h"
#include "resource.h"
#include "command.h"

/**
  *@author Troy Corbin Jr.
  */

class KLineEdit;
class KnightsTextView;

class Console : public TQVBox
{
	TQ_OBJECT
  

	public:

		enum Direction
		{
			Up					= 1,
			Down				= 0
		};

														Console(TQWidget *parent=0, const char *name=0, resource *Rsrc=0);
														~Console();
		void										buildAccel( void );

	public slots:
		void										recvCMD( const Command& );
		void										getText( const TQString& );
		void										historyBackward( void );
		void										historyForward( void );
		void										pageUp( void );
		void										pageDown( void );
		void										getFocus( void );
		void										getFocus( const TQChar& );
		void										setBG( void );
		void										replyPrivate( void );
		void										replyChannel( void );
		void										kibitz( void );
		void										whisper( void );

	signals:
		void										sendCMD( const Command& );

	private:
		TQString									insertTags(TQString);

		resource								*myResource;
		int											margin;
		bool										SelfMoving;

		KnightsTextView					*myTextView;
		KLineEdit								*myLineEdit;

		TQStringList							history;
		TQStringList::Iterator		historyIT;
		TQString									lastPrivateSource;
		TQString									lastChannelSource;
};

#endif
