/***************************************************************************
                          tdesudo.cpp  -  description
                             -------------------
    begin                : Sam Feb 15 15:42:12 CET 2003
    copyright            : (C) 2003 by Robert Gruber <rgruber@users.sourceforge.net>
                           (C) 2007 by Martin Böhm <martin.bohm@kubuntu.org>
                                       Anthony Mercatante <tonio@kubuntu.org>
                                       Canonical Ltd (Jonathan Riddell <jriddell@ubuntu.com>)

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TDESUDO_H
#define TDESUDO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tqwidget.h>
#include <kpassdlg.h>
#include <tqstring.h>
#include <tqtextcodec.h>
#include <kprocess.h>
class KCookie;

/*
* TdeSudo is the base class of the project
*
* It inherits KPasswordDialog and overrrides the
* slot slotOK()
*
* @author Robert Gruber <rgruber@users.sourceforge.net>
* @version 2.4
*/

class TdeSudo : public KPasswordDialog
{
	TQ_OBJECT
	

public:
	/*
	* Default construtor
	*/
	TdeSudo(TQWidget* parent=0, const char *name=0, const TQString& icon=TQString(), const TQString& generic=TQString(), bool withIgnoreButton=false);

	/*
	* Default destructor
	*/
	~TdeSudo();
	enum ResultCodes { AsUser = 10 };

public slots: // Public slots
	/*
	* This slot gets exectuted if sudo creates some output
	*/
	void receivedOut(TDEProcess*proc, char*buffer, int buflen);
	/*
	* This slot gets exectuted when sudo exits
	*/
	void procExited(TDEProcess *proc);
	/*
	* This slot overrides the slot from KPasswordDialog
	* @see KPasswordDialog
	*/
	void slotOk();
	void slotUser1();
	TQString validArg(TQString arg);

private: // Private attributes
	TDEProcess * p;
	bool bError;
	bool newDcop;
	bool keepPwd;
	bool emptyPwd;
	bool useTerm;
	bool noExec;
	bool unCleaned;
	TQString m_tmpname;
	TQString iceauthorityFile;
	TQString dcopServer;
	TQString kdeSycoca;
	KCookie* m_pCookie;
	void blockSigChild();
	void unblockSigChild();
};

#endif
