/***************************************************************************
    smb4kmounter_p  -  This is a private helper class for Smb4KMounter.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/


// application specific includes
#include "smb4kmounter_p.h"

Smb4KMounterPrivate::Smb4KMounterPrivate()
{
  timerTicks = 0;
  clearData();
}


Smb4KMounterPrivate::~Smb4KMounterPrivate()
{
}


void Smb4KMounterPrivate::clearData()
{
  m_workgroup = TQString();
  m_host = TQString();
  m_share = TQString();
  m_ip = TQString();
  m_path = TQString();
  m_filesystem = TQString();
  m_cifsLogin = TQString();
}


const TQString &Smb4KMounterPrivate::workgroup()
{
  return m_workgroup;
}


const TQString &Smb4KMounterPrivate::host()
{
  return m_host;
}


const TQString &Smb4KMounterPrivate::share()
{
  return m_share;
}


const TQString &Smb4KMounterPrivate::ip()
{
  return m_ip;
}


const TQString &Smb4KMounterPrivate::path()
{
  return m_path;
}


const TQString &Smb4KMounterPrivate::filesystem()
{
  return m_filesystem;
}


const TQString &Smb4KMounterPrivate::cifsLogin()
{
  return m_cifsLogin;
}


void Smb4KMounterPrivate::setWorkgroup( const TQString &wg )
{
  m_workgroup = wg;
}


void Smb4KMounterPrivate::setHost( const TQString &h )
{
  m_host = h;
}


void Smb4KMounterPrivate::setShare( const TQString &s )
{
  m_share = s;
}


void Smb4KMounterPrivate::setIP( const TQString &i )
{
  m_ip = i;
}


void Smb4KMounterPrivate::setPath( const TQString &p )
{
  m_path = p;
}


void Smb4KMounterPrivate::setFileSystem( const TQString &f )
{
  m_filesystem = f;
}


void Smb4KMounterPrivate::setCIFSLogin( const TQString &l )
{
  m_cifsLogin = l;
}
