/*  This file is part of the TDE project
    Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#ifndef POLKIT_LISTENER_H
#define POLKIT_LISTENER_H

#include <PolkitTQt/Agent/Listener>

class AuthDialog;

class PolkitListener : public PolkitTQt::Agent::Listener
{
  TQ_OBJECT

  public:
    PolkitListener(TQObject *parent = 0);

  public slots:
    void initiateAuthentication(const TQString &actionId, const TQString &message,
            const TQString &iconName, const PolkitTQt::Details &details,
            const TQString &cookie, const PolkitTQt::Identity::List &identities,
            PolkitTQt::Agent::AsyncResult* result);
    bool initiateAuthenticationFinish();
    void cancelAuthentication();

    void tryAgain();
    void finishObtainPrivilege();

    void request(const TQString &request, bool _);
    void completed(bool gainedAuthorization);
    void showError(const TQString &text);

  private:
    void clearSession();

    AuthDialog *m_dialog;
    bool m_inProgress;
    bool m_gainedAuthorization;
    bool m_wasCancelled;
    int  m_numTries;
    TQString m_cookie;
    PolkitTQt::Identity::List m_identities;
    PolkitTQt::Identity m_selectedUser;
    PolkitTQt::Agent::AsyncResult* m_result;
    PolkitTQt::Agent::Session *m_session;

  private slots:
    void dialogAccepted();
    void dialogCanceled();
    void userSelected(const PolkitTQt::Identity &identity);
};

#endif

