/***************************************************************************
                          dlg_server.cpp  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kicontheme.h>
#include "dlg_server.moc"

dlg_server::dlg_server(TQWidget *parent, const char *name, resource *Rsrc, TQString ItemName ) :
	KDialogBase(	parent,
								name,						
								true,
								i18n("Configure Server"),
								Help|Ok|Apply|Cancel,
								Ok,		
								true )
{
	Resource = Rsrc;
	Name = ItemName;

	BOX_Parent = makeVBoxMainWidget();
	
	BOX_Name = new TQGroupBox( 1,
														TQt::Horizontal,
														i18n( "Server Name" ),
														BOX_Parent );
	EDIT_Name = new KLineEdit( BOX_Name );
	
	BOX_URLPort = new TQHBox( BOX_Parent );
	BOX_URL = new TQGroupBox( 1,
																TQt::Horizontal,
																i18n( "Server URL" ),
																BOX_URLPort );
	EDIT_URL = new KLineEdit( BOX_URL );
	BOX_Port = new TQGroupBox( 1,
																TQt::Horizontal,
																i18n( "Server Port" ),
																BOX_URLPort );
	EDIT_Port = new KLineEdit( BOX_Port );
	
	BOX_UNameStore = new TQHBox( BOX_Parent );
	BOX_UserName = new TQGroupBox( 1,
																	TQt::Horizontal,
																	i18n( "Username" ),
																	BOX_UNameStore );
	EDIT_UserName = new KLineEdit( BOX_UserName );
	CHECK_StorePass = new TQCheckBox( i18n( "Remember My Password" ), BOX_UNameStore );
	
	BOX_Pass = new TQHBox( BOX_Parent );
	BOX_Password = new TQGroupBox( 1,
																	TQt::Vertical,
																	i18n( "Password" ),
																	BOX_Pass );
	EDIT_Password = new KLineEdit( BOX_Password );
	EDIT_Password->setEchoMode( TQLineEdit::Password );
	
	BOX_PasswordRetype = new TQGroupBox( 1,
																	TQt::Vertical,
																	i18n( "Confirm Password" ),
																	BOX_Pass );
	EDIT_PasswordRetype = new KLineEdit( BOX_PasswordRetype );
	EDIT_PasswordRetype->setEchoMode( TQLineEdit::Password );
	
	/* Use Timeseal? */
	GROUP_Timeseal = new TQGroupBox( 2,
																		TQt::Horizontal,
																		i18n( "Timeseal" ),
																		BOX_Parent );
	EDIT_Timeseal = new KLineEdit( GROUP_Timeseal );
	BUTTON_Timeseal = new TQPushButton( GROUP_Timeseal );
	BUTTON_Timeseal->setPixmap( Resource->LoadIcon( TQString( "document-open" ), TDEIcon::Toolbar ) );
	connect( BUTTON_Timeseal, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slot_Timeseal() ) );

	BOX_LogFile = new TQGroupBox( 2,
																TQt::Horizontal,
																i18n( "Log File" ),
																BOX_Parent );
	EDIT_LogFile = new KLineEdit( BOX_LogFile );
	BUTTON_LogFile = new TQPushButton( BOX_LogFile );
	
	setMainWidget( BOX_Parent );
	BUTTON_LogFile->setPixmap( Resource->LoadIcon( TQString( "document-open" ), TDEIcon::Toolbar ) );
	EDIT_Name->setMinimumWidth( 120 );
	EDIT_URL->setMinimumWidth( 120 );
	EDIT_UserName->setMinimumWidth( 120 );
	EDIT_Password->setMinimumWidth( 120 );
	EDIT_PasswordRetype->setMinimumWidth( 120 );
	/* Load in data if this is a modification */
	if( !Name.isEmpty() )
	{
		for ( serversIT = Resource->servers.begin(); serversIT != Resource->servers.end(); ++serversIT )
		{
			if( (*serversIT).Name == Name ) break;
		}
		EDIT_Name->setText( (*serversIT).Name );
		EDIT_URL->setText( (*serversIT).URL );
		EDIT_Port->setText( TQString("").setNum( (*serversIT).Port ) );
		EDIT_UserName->setText( (*serversIT).UserName );
		CHECK_StorePass->setChecked( (*serversIT).StorePass );
		EDIT_Password->setText( (*serversIT).Password );
		EDIT_PasswordRetype->setText( (*serversIT).Password );
		EDIT_LogFile->setText( (*serversIT).LogFile );
		EDIT_Timeseal->setText( (*serversIT).Timeseal );
	}
	if( CHECK_StorePass->isChecked() )
	{
		EDIT_Password->setEnabled( true );
		EDIT_PasswordRetype->setEnabled( true );
	}
	else
	{
		EDIT_Password->setEnabled( false );
		EDIT_PasswordRetype->setEnabled( false );
	}
	/* Init the buttons */
	showButtonCancel( true );
	showButtonOK( true );
	showButtonApply( true );
	showButton( Help, true );

	enableButtonCancel( true );
	enableButtonOK( true );
	enableButtonApply( false );
	enableButton( Help, true );

	setHelp( TQString( "configure-servers" ) );
	/* Make Connections */
	connect( BUTTON_LogFile, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotLogFileDialog() ) );
	connect( CHECK_StorePass, TQ_SIGNAL( toggled(bool) ), this, TQ_SLOT( slotStorePass(bool) ) );
	connect( EDIT_Name, TQ_SIGNAL( textChanged( const TQString&) ), this, TQ_SLOT( slotEnableApply( const TQString&) ) );
	connect( EDIT_URL, TQ_SIGNAL( textChanged( const TQString&) ), this, TQ_SLOT( slotEnableApply( const TQString&) ) );
	connect( EDIT_Port, TQ_SIGNAL( textChanged( const TQString&) ), this, TQ_SLOT( slotEnableApply( const TQString&) ) );
	connect( EDIT_UserName, TQ_SIGNAL( textChanged( const TQString&) ), this, TQ_SLOT( slotEnableApply( const TQString&) ) );
	connect( EDIT_Password, TQ_SIGNAL( textChanged( const TQString&) ), this, TQ_SLOT( slotEnableApply( const TQString&) ) );
	connect( EDIT_Timeseal, TQ_SIGNAL( textChanged( const TQString&) ), this, TQ_SLOT( slotEnableApply( const TQString&) ) );
	show();
}
dlg_server::~dlg_server()
{
}

void dlg_server::slotOk( void )
{
	slotApply();
	slotDelayedDestruct();
}

void dlg_server::slotApply( void )
{
	serverResource newServer;

	if( ( EDIT_Password->text() != EDIT_PasswordRetype->text() ) && ( CHECK_StorePass->isChecked() ) )
	{
		return;
	}
	if( Name.isEmpty() )
	{
		serversIT = Resource->servers.append( newServer );
		Name = "notemptyanymore";
		(*serversIT).CurrentRef = 0;
	}
	(*serversIT).Name = EDIT_Name->text();
	(*serversIT).URL = EDIT_URL->text();
	(*serversIT).Port = TQString( EDIT_Port->text() ).toInt();
	(*serversIT).UserName = EDIT_UserName->text();
	(*serversIT).Password = EDIT_Password->text();
	(*serversIT).LogFile = EDIT_LogFile->text();
	(*serversIT).StorePass = CHECK_StorePass->isChecked();
	(*serversIT).Timeseal = EDIT_Timeseal->text();
	
	enableButtonApply( false );
}

void dlg_server::slotCancel( void )
{
	slotDelayedDestruct();
}

void dlg_server::slotLogFileDialog( void )
{
	TQString temp;

	temp = KFileDialog::getOpenFileName(	TQString(),
																				TQString( "*" ),
																				this,
																				TQString( "Find Log..." ) );
	if( temp.isEmpty() ) return;
	EDIT_LogFile->setText( temp );
	enableButtonApply( true );
}

void dlg_server::slotEnableApply( const TQString& )
{
	enableButtonApply( true );
}

void dlg_server::slotStorePass( bool )
{
	if( CHECK_StorePass->isChecked() )
	{
		EDIT_Password->setEnabled( true );
		EDIT_PasswordRetype->setEnabled( true );
	}
	else
	{
		EDIT_Password->setEnabled( false );
		EDIT_PasswordRetype->setEnabled( false );
	}
	enableButtonApply( true );
}
///////////////////////////////////////
//
//	dlg_server::slot_Timeseal
//
///////////////////////////////////////
void dlg_server::slot_Timeseal( void )
{
	TQString temp;

	temp = KFileDialog::getOpenFileName(	TQString(),
																				TQString( "*" ),
																				0,
																				TQString( "Find Timeseal..." ) );
	if( temp.isEmpty() ) return;
	EDIT_Timeseal->setText( temp );
	enableButtonApply( true );
}

