/***************************************************************************
*   Copyright (C) 2005 by Alexander Nemish  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BOOKWIDGET_H
#define BOOKWIDGET_H

#include <tqwidget.h>
#include <tqevent.h>
#include <tqpixmap.h>
#include <tqthread.h>
#include <tqtimer.h>
#include <tqfile.h>
#include <kurl.h>
#include <algorithm>
#include "renderer.h"
#include "bookmark.h"

class TQStringList;
class TQRect;
class KProgressDialog;


/**
 */
class BookWidget : public TQWidget
{
	TQ_OBJECT
  
public:
	
	
	BookWidget(TQWidget *parent = 0, const char *name = 0);
	~BookWidget();

	virtual void openURL(const KURL & url);
	virtual TQString currentURL();
	void paintEvent (TQPaintEvent *);
	void setFont( const TQFont & );
	void setParaOffset(int offset);
	void setCurrentPage(int number);
	int  currentPage() const { return m_currentPage; };
	int  pageCount() const { return m_renderer->pageCount(); }
	void nextPage();
	void prevPage();
	void firstPage();
	void lastPage();
	TQSize minimumSizeHint () const;
	void setupPageSize();
	void setEncoding(int);
	void setEncoding(const TQString & a_encoding);
	void setEncodings(const TQStringList & a_encodings);
	TQString encoding() const { return m_encodings[m_encoding]; }
	//const TextThread * thread() const {return m_thread;}
	void addBookmark(const TQString& name);
	void saveBookmarks();
	void loadBookmarks();
	void setBookmarks(const Bookmarks& bms);
	const Bookmarks & bookmarks() const { return m_bookmarks; }
signals:
	/**
	 * Use this signal to change the content of the statusbar
	 */
	void signalChangeStatusbar(const TQString& text);

	/**
	 * Use this signal to change the content of the caption
	 */
	void signalChangeCaption(const TQString& text);

	void loaded(int);
	void loadingFinished();
protected:
	const TQRect rectLeftPage() const;
	const TQRect rectRightPage() const;
	void mousePressEvent(TQMouseEvent *);
	void keyPressEvent (TQKeyEvent * e);
	void resizeEvent (TQResizeEvent * e);
	void wheelEvent (TQWheelEvent * e);
	void clearAll();
	void drawContent(TQPainter& paint);
	void drawPageNumbers(TQPainter& paint);
	void drawBookmark(TQPainter& paint, Bookmark const& bm);
	bool modified() const { return m_modified; };

private slots:
	void loadLine();
	void cancelLoading();
	void renderingFinished();
	
private:
	KURL	m_url;
	bool m_modified;
	TQPixmap m_cachePixmap;
	int m_currentPage;
	int m_left_margin;
	int m_right_margin;
	int m_top_margin;
	int m_bottom_margin;
	int m_middle_margin;
	TQFile m_file;
	TQTimer m_timer;
	TQStringList m_encodings;
	int m_encoding;
	std::unique_ptr<Renderer> m_renderer;
	std::unique_ptr<TQTextStream> m_stream;
	std::unique_ptr<TQStringList> m_textLines;
	std::unique_ptr<KProgressDialog> m_progressDlg;
	Bookmarks m_bookmarks;
};

#endif
