//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "k9mencodercmdgen.h"
#include <tqscrollview.h>
#include <tqtabwidget.h>
#include <tqfile.h>
#include <tqdom.h>
#include <tqlabel.h>
#include <knuminput.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqframe.h>
#include <tqwidgetstack.h>
#include <tdelocale.h>
#include <tqheader.h>
#include <tqlayout.h>
#include <tqvbox.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include <kstandarddirs.h>
#include <tdeapplication.h>
class _k9CheckListItem: public TQCheckListItem {
public:
    _k9CheckListItem(TQListViewItem *_item):TQCheckListItem(_item,"",TQCheckListItem::CheckBox) {};
    TQString root;
    TQDomDocument doc;
    int page;
    TQFrame *frame;
    int rtti () const {return 1001;}
protected:
    void stateChange(bool _state);
};

void _k9CheckListItem::stateChange(bool _state) {
    TQDomElement eRoot=doc.documentElement().elementsByTagName(root).item(0).toElement();
    TQDomElement eCodec=eRoot.elementsByTagName(text()).item(0).toElement();
    eCodec.setAttribute("selected",_state?"true":"false");
}


k9MencoderCmdGen::k9MencoderCmdGen(TQWidget* parent, const TQString &_cmd, bool modal, WFlags fl)
: MyDialog1(parent,"", modal,fl)
{
    setCaption(kapp->makeStdCaption(i18n("MEncoder options")));
    m_row=0; m_page=1;
    loadXml();
    parseCmd(_cmd);

    fillListView();
}

void k9MencoderCmdGen::fillListView() {
    listView->clear();
    listView->header()->hide();
    TQListViewItem *item=new TQListViewItem(listView);
    item->setOpen(true);
    item->setText(0,i18n("Audio Codec"));
    TQDomElement root=m_doc.documentElement().elementsByTagName("AUDIO").item(0).toElement();
    for (int i=0; i< root.childNodes().count();i++) {
        TQDomElement eChild=root.childNodes().item(i).toElement();
        _k9CheckListItem *child=new _k9CheckListItem(item);
        child->setText(0,eChild.nodeName());
        child->root="AUDIO";
        child->doc=m_doc;
        TQDomAttr attr=eChild.attributeNode("selected");
        if (!attr.isNull())
            child->setOn(attr.value()=="true");

        addWidgets(child, "AUDIO",eChild.nodeName());

    }
    item=new TQListViewItem(listView);
    item->setText(0,i18n("Video Codec"));
    item->setOpen(true);
    root=m_doc.documentElement().elementsByTagName("VIDEO").item(0).toElement();
    for (int i=0; i< root.childNodes().count();i++) {
        TQDomElement eChild=root.childNodes().item(i).toElement();
        _k9CheckListItem *child=new _k9CheckListItem(item);
        child->setText(0,eChild.nodeName());
        child->root="VIDEO";
        child->doc=m_doc;
        TQDomAttr attr=eChild.attributeNode("selected");
        if (!attr.isNull())
            child->setOn(attr.value()=="true");

        addWidgets(child, "VIDEO",eChild.nodeName());


    }

    item=new TQListViewItem(listView);
    item->setText(0,i18n("Filters"));
    item->setOpen(true);
    root=m_doc.documentElement().elementsByTagName("FILTERS").item(0).toElement();
    for (int i=0; i< root.childNodes().count();i++) {
        TQDomElement eChild=root.childNodes().item(i).toElement();
        _k9CheckListItem *child=new _k9CheckListItem(item);
        child->setText(0,eChild.nodeName());
        child->root="FILTERS";
        child->doc=m_doc;
        TQDomAttr attr=eChild.attributeNode("selected");
        if (!attr.isNull())
            child->setOn(attr.value()=="true");

        addWidgets(child, "FILTERS",eChild.nodeName());
    }

}

k9MencoderCmdGen::~k9MencoderCmdGen()
{
}

/*$SPECIALIZATION$*/

void k9MencoderCmdGen::listViewCurrentChanged(TQListViewItem *_item) {
    if (_item->parent() == NULL)
        wsOptions->raiseWidget(0);
    else if (_item->rtti()==1001) {
        _k9CheckListItem *item=(_k9CheckListItem*) _item;
        wsOptions->raiseWidget(item->page);
    

    }    
}

void k9MencoderCmdGen::loadXml() {
    TQFile file(TDEGlobal::dirs()->findResource( "data", "k9copy/mencoder.xml"));
    if ( !file.open( IO_ReadOnly ) )
        return;
    if ( !m_doc.setContent( &file ) ) {
        file.close();
        return;
    }
    file.close();


 }

void k9MencoderCmdGen::addWidgets(_k9CheckListItem *_listItem,TQString _root,TQString _cat) {
    m_cpt=0;
    TQVBox *vbox=new TQVBox(wsOptions);
    wsOptions->addWidget(vbox,m_page);
    _listItem->page=m_page;
    m_page++;

    TQFrame *fr=new TQFrame(vbox);
    _listItem->frame=fr;

    
    TQGridLayout *m_grid1=new TQGridLayout(fr,1,1,0,0);
    m_scrollView=new TQScrollView(fr,0);
    m_scrollView->viewport()->setPaletteBackgroundColor(this->paletteBackgroundColor());
    m_scrollView->setVScrollBarMode(TQScrollView::AlwaysOn);
    m_grid1->addWidget(m_scrollView,0,0);

    m_grid=new TQGrid(2,m_scrollView->viewport());
    m_grid->setSpacing(2);
    m_scrollView->addChild(m_grid);


   //finds the VIDEO node
    TQDomElement eVideo=m_doc.documentElement().elementsByTagName(_root).item(0).toElement();
    //gets the codec list
    TQDomNodeList lCodecs=eVideo.elementsByTagName(_cat);
    for (int i=0; i<lCodecs.count();i++) {
        TQDomElement eCodec=lCodecs.item(i).toElement();
        //gets codec options
        TQDomNodeList lOptions=eCodec.elementsByTagName("opt");
        for (int j=0;j<lOptions.count();j++) {
            TQDomElement eOpt=lOptions.item(j).toElement();
            TQDomAttr aType=eOpt.attributeNode("type");
            if (aType.value() == "int")
                addInt(eOpt);
            else if(aType.value()=="float")
                addFloat(eOpt);
            else if (aType.value()=="bool")
                addBool(eOpt);
            else if (aType.value()=="string")
                addString(eOpt);
            else if (aType.value()=="")
                addList(eOpt);
        }
    }
}

void k9MencoderCmdGen::addList(TQDomElement _eOpt) {
   TQString sName=_eOpt.attributeNode("name").value();
   bool bSel=false;
   TQDomAttr aSel=_eOpt.attributeNode("selected");
   if (!aSel.isNull())
       bSel=aSel.value()=="true";


   TQCString ckLabelName = TQString("ck%1").arg(m_row++).utf8();
   TQCheckBox *ckLabel=new TQCheckBox(sName,m_grid,ckLabelName);
   ckLabel->setChecked(bSel);
   m_hbox=new TQGrid(2,m_grid);
   m_hbox->setFrameShape(TQFrame::StyledPanel);
   m_hbox->setFrameShadow(TQFrame::Raised);

   if ( !_eOpt.attributeNode("description").isNull())  {
        TQToolTip::add(ckLabel,_eOpt.attributeNode("description").value());
        TQWhatsThis::add(ckLabel,_eOpt.attributeNode("description").value());
   }


    TQDomNodeList lOption=_eOpt.elementsByTagName("subopt");
    for (int i=0; i<lOption.count();i++) {
        TQDomElement eSubOpt=lOption.item(i).toElement();
        TQDomAttr aType=eSubOpt.attributeNode("type");
        if (aType.value() == "int")
            addInt(eSubOpt);
        else if(aType.value()=="float")
            addFloat(eSubOpt);
        else if (aType.value()=="bool")
            addBool(eSubOpt);
        else if (aType.value()=="string")
            addString(eSubOpt);
    }

  _eOpt.setAttribute("checkbox",ckLabel->name());

}


void k9MencoderCmdGen::addInt(TQDomElement _eOpt) {
   TQString sName=_eOpt.attributeNode("name").value();
   bool blist=false;
   if (_eOpt.nodeName()=="subopt")
        blist=true; 

   int iMin=_eOpt.attributeNode("min").value().toInt();
   int iMax=_eOpt.attributeNode("max").value().toInt();
   int iDefault=_eOpt.attributeNode("default").value().toInt();

   TQWidget *parent;
   if (!blist) {
       parent=m_grid;
   } else
       parent=m_hbox;

    bool bSel=false;
    TQDomAttr aSel=_eOpt.attributeNode("selected");
    if (!aSel.isNull())
        bSel=aSel.value()=="true";

    TQCString ckLabelName = TQString("ck%1").arg(m_row++).utf8();
    TQCheckBox *ckLabel=new TQCheckBox(sName,parent,ckLabelName);
    ckLabel->setChecked(bSel);
    ckLabel->setBackgroundColor(parent->backgroundColor());

    if ( !_eOpt.attributeNode("description").isNull()) {
        TQToolTip::add(ckLabel,_eOpt.attributeNode("description").value());
        TQWhatsThis::add(ckLabel,_eOpt.attributeNode("description").value());
    }
    _eOpt.setAttribute("checkbox",ckLabel->name());


   TQCString sbName = TQString("int%1").arg(m_row++).utf8();
   KIntSpinBox *sb= new KIntSpinBox(iMin,iMax,1,iDefault,10,parent,sbName);
   if (iMax <1000)
        sb->setFixedWidth(50);
    else   
        sb->setFixedWidth(100);
    if( !_eOpt.attributeNode("special").isNull()){
        sb->setSpecialValueText(_eOpt.attributeNode("special").value());
        if (_eOpt.attributeNode("special").value()== _eOpt.attributeNode("default").value())
            sb->setValue(iMin-1);

    }

   _eOpt.setAttribute("widget",sb->name());

   //m_grid->addWidget(label,m_row++,0);
}
void k9MencoderCmdGen::addFloat(TQDomElement _eOpt) {
   TQString sName=_eOpt.attributeNode("name").value();
   double dMin=_eOpt.attributeNode("min").value().toDouble();
   double dMax=_eOpt.attributeNode("max").value().toDouble();
   double dDefault=_eOpt.attributeNode("default").value().toDouble();
   bool bSel=false;
   bool blist=false;
    if (_eOpt.nodeName()=="subopt")
        blist=true; 
  
   TQWidget *parent;
   if (!blist) {
      parent=m_grid;
   } else
       parent=m_hbox;
    TQDomAttr aSel=_eOpt.attributeNode("selected");
    if (!aSel.isNull())
        bSel=aSel.value()=="true";
    
    TQCString ckLabelName = TQString("ck%1").arg(m_row++).utf8();
    TQCheckBox *ckLabel=new TQCheckBox(sName,parent,ckLabelName);
    ckLabel->setChecked(bSel);
    if ( !_eOpt.attributeNode("description").isNull()) {
            TQToolTip::add(ckLabel,_eOpt.attributeNode("description").value());
            TQWhatsThis::add(ckLabel,_eOpt.attributeNode("description").value());
    }
    _eOpt.setAttribute("checkbox",ckLabel->name());

   double dStep=0.01;
   int iPrecision=2;
   if (!_eOpt.attributeNode("step").isNull()) {
        dStep=_eOpt.attributeNode("step").value().toDouble();
    }
   if (!_eOpt.attributeNode("precision").isNull()) {
        iPrecision=_eOpt.attributeNode("precision").value().toInt();
    }
   TQCString sbName = TQString("float%1").arg(m_row++).utf8();
   KDoubleSpinBox *sb= new KDoubleSpinBox(dMin,dMax,dStep,dDefault,iPrecision,parent,sbName);
   if (dMax <1000)
        sb->setFixedWidth(80);
    else   
        sb->setFixedWidth(120);
    if( !_eOpt.attributeNode("special").isNull()){
        sb->setSpecialValueText(_eOpt.attributeNode("special").value());
    }
   
   _eOpt.setAttribute("widget",sb->name());
}

void k9MencoderCmdGen::addBool(TQDomElement _eOpt) {
   TQString sName=_eOpt.attributeNode("name").value();
   bool blist=false;
   if (_eOpt.nodeName()=="subopt")
        blist=true; 

   bool bSel=false;
   TQWidget *parent;
   if (!blist) {
        parent = m_grid;
   } else
        parent = m_hbox;

    TQDomAttr aSel=_eOpt.attributeNode("selected");
    if (!aSel.isNull())
        bSel=aSel.value()=="true";

    TQCString ckLabelName = TQString("ck%1").arg(m_row++).utf8();
    TQCheckBox *ckLabel=new TQCheckBox(sName,parent,ckLabelName);

    if ( !_eOpt.attributeNode("description").isNull()) {
        TQToolTip::add(ckLabel,_eOpt.attributeNode("description").value());
        TQWhatsThis::add(ckLabel,_eOpt.attributeNode("description").value());
    }
    TQWidget *w=new TQWidget(parent);

    if ((_eOpt.attributeNode("default").value()=="true") && bSel)
        ckLabel->setChecked(true);   

   _eOpt.setAttribute("checkbox",ckLabel->name());

}

void k9MencoderCmdGen::addString(TQDomElement _eOpt) {
   TQString sName=_eOpt.attributeNode("name").value();
   bool blist=false;
   if (_eOpt.nodeName()=="subopt")
        blist=true; 
    
   TQString sDefault=_eOpt.attributeNode("default").value();
   TQWidget *parent;
   if( !blist) {
        parent=m_grid;
   } else
        parent=m_hbox;

    bool bSel=false;
    TQDomAttr aSel=_eOpt.attributeNode("selected");
    if (!aSel.isNull())
        bSel=aSel.value()=="true";
    
    TQCString ckLabelName = TQString("ck%1").arg(m_row++).utf8();
    TQCheckBox *ckLabel=new TQCheckBox(sName,parent,ckLabelName);
    ckLabel->setChecked(bSel);
    if ( !_eOpt.attributeNode("description").isNull()) {
            TQToolTip::add(ckLabel,_eOpt.attributeNode("description").value());
            TQWhatsThis::add(ckLabel,_eOpt.attributeNode("description").value());
    }
   _eOpt.setAttribute("checkbox",ckLabel->name());

   TQCString cbName = TQString("string%1").arg(m_row++).utf8();
   TQComboBox *cb=new TQComboBox(parent,cbName);
   
   TQDomNodeList values=_eOpt.elementsByTagName("value");
   int def=0;
   if (values.count()==0) {
        cb->setEditable(true);
        cb->setCurrentText(sDefault);
  } else {
        for (int i=0;i<values.count();i++) {
            TQDomElement e=values.item(i).toElement();
            cb->insertItem(e.attributeNode("name").value());
            if (e.attributeNode("name").value() ==sDefault)
                def=cb->count()-1;
        }
        cb->setCurrentItem(def);
    }
   _eOpt.setAttribute("widget",cb->name());

}

const TQString & k9MencoderCmdGen::getCmd(const TQString &_root) {
 /*   TQString str;
    TQTextStream ts(&str,IO_WriteOnly);
    m_doc.save(ts,4);
    TQFile f ("/home/jmp/doc.xml");
    f.open(IO_WriteOnly);
    f.writeBlock(str.latin1(),str.length());
    f.close();
*/
    m_cmd="";
    TQString m_sepOpt=":";
    TQString m_sepValues=",";
    //finds the VIDEO node
    TQDomElement eRoot=m_doc.documentElement().elementsByTagName(_root).item(0).toElement();

    //gets the codec list
    TQDomNodeList lCodecs=eRoot.childNodes();
    for (int i=0; i<lCodecs.count();i++) {
        TQString sCmd="",sCmd1="";
        TQDomElement eCodec=lCodecs.item(i).toElement();
        TQDomAttr eSep=eCodec.attributeNode("separator");
        if (!eSep.isNull())
            m_sepOpt=eSep.value();

        TQDomAttr eAttr=eCodec.attributeNode("selected");
        if (eAttr.isNull())
            continue;
        if (eAttr.value()=="false")
            continue;

        //gets codec options
        TQDomNodeList lOptions=eCodec.elementsByTagName("opt");
        for (int j=0;j<lOptions.count();j++) {
            TQDomElement eOpt=lOptions.item(j).toElement();
            TQDomAttr aType=eOpt.attributeNode("type");  
            TQDomAttr aCheckBox=eOpt.attributeNode("checkbox");
            TQDomAttr aWidget=eOpt.attributeNode("widget");
            TQCheckBox *ck=(TQCheckBox*)this->child(aCheckBox.value().latin1());
            if (ck->isChecked()) {
                if (sCmd1.isEmpty()){
                    if (eCodec.attributeNode("options").isNull())
                        sCmd1=" -"+eCodec.tagName()+" ";
                    else
                        sCmd1=eCodec.tagName()+" -"+eCodec.attributeNode("options").value()+" ";

                }
                if(aType.isNull()) {
                    //build list
                    eSep=eOpt.attributeNode("separator");
                    if (!eSep.isNull())
                        m_sepValues=eSep.value();
                    TQDomNodeList lSubOpt=eOpt.elementsByTagName("subopt");
                    TQString sCmd2="";
                    TQString sTmp="";
                    for (int k=0;k<lSubOpt.count();k++) {
                        TQDomElement eSOpt=lSubOpt.item(k).toElement();
                        TQDomAttr aSType=eSOpt.attributeNode("type");  
                        TQDomAttr aSWidget=eSOpt.attributeNode("widget");
                        TQString sPrefix="";
                        if (!eSOpt.attributeNode("prefix").isNull())
                            sPrefix=eSOpt.attributeNode("prefix").value();
                        TQCheckBox *Sck=(TQCheckBox*)this->child(eSOpt.attributeNode("checkbox").value().latin1());
                        if(aSType.value()=="int" && Sck->isChecked()) {
                            KIntSpinBox *isb=(KIntSpinBox*) this->child(aSWidget.value().latin1(),"KIntSpinBox");
                            if (!sCmd2.isEmpty())
                                sCmd2 +=m_sepValues;
                            sCmd2+=sTmp+sPrefix+isb->text().stripWhiteSpace() ;      
                            sTmp="";
                        } else if(aSType.value()=="float" && Sck->isChecked()) {
                            KDoubleSpinBox *isb=(KDoubleSpinBox*) this->child(aSWidget.value().latin1(),"KDoubleSpinBox");
                            if (!sCmd2.isEmpty())
                                sCmd2 +=m_sepValues;
                            sCmd2+=sTmp+sPrefix+isb->text().replace(",",".").stripWhiteSpace();      
                            sTmp="";
                        } else if(aSType.value()=="string" && Sck->isChecked()) {
                            TQComboBox *cb=(TQComboBox*) this->child(aSWidget.value().latin1(),"TQComboBox");
                            if (!sCmd2.isEmpty() )
                                sCmd2 +=m_sepValues;
                           // sCmd2+= cb->text(cb->currentItem());
                            sCmd2+= sTmp+ sPrefix+cb->currentText();
                            sTmp="";
                        }else if(aSType.value()=="bool" && Sck->isChecked()) {
                            if (!sCmd2.isEmpty() )
                                sCmd2 +=m_sepValues;
                            sCmd2+= sTmp+ eSOpt.attributeNode("name").value();
                            sTmp="";                        
                        } else if(sPrefix==""){
                                sTmp +=m_sepValues;
                        }
                    }
                    if (!sCmd.isEmpty())
                        sCmd +=m_sepOpt;;
                    sCmd+= eOpt.attributeNode("name").value() + "=" +sCmd2;
                }else if(aType.value()=="int") {
                    KIntSpinBox *isb=(KIntSpinBox*) this->child(aWidget.value().latin1(),"KIntSpinBox");
                    if (!sCmd.isEmpty())
                        sCmd +=m_sepOpt;
                    sCmd+= eOpt.attributeNode("name").value() + "=" + isb->text();
                } else if(aType.value()=="float") {
                    KDoubleSpinBox *isb=(KDoubleSpinBox*) this->child(aWidget.value().latin1(),"KDoubleSpinBox");
                    if (!sCmd.isEmpty())
                        sCmd +=m_sepOpt;
                    sCmd+= eOpt.attributeNode("name").value() + "=" + isb->text().replace(",",".");
                } else if(aType.value()=="string") {
                    TQComboBox *cb=(TQComboBox*) this->child(aWidget.value().latin1(),"TQComboBox");
                    if (!sCmd.isEmpty())
                        sCmd +=m_sepOpt;
                    sCmd+= eOpt.attributeNode("name").value() + "=" + cb->currentText();
                } else if(aType.value()=="bool") {
                    if (!sCmd.isEmpty()) 
                            sCmd +=m_sepOpt;
                    sCmd+=eOpt.attributeNode("name").value() ;
                }
            }
        }
        m_cmd+=sCmd1+sCmd;

    }
    
    return m_cmd;
}

bool k9MencoderCmdGen::getMencoderOptions(TQString &_cmd) {
    k9MencoderCmdGen * m_cmdGen=new k9MencoderCmdGen(NULL,_cmd);
    m_cmdGen->m_cmd=_cmd;
    bool res=m_cmdGen->exec();
    if (res) {
        TQString m_video=m_cmdGen->getCmd("VIDEO").stripWhiteSpace();
        TQString m_audio=m_cmdGen->getCmd("AUDIO").stripWhiteSpace();
        TQString m_filters=m_cmdGen->getCmd("FILTERS").stripWhiteSpace();
        if (!m_video.isEmpty())
            m_video="-ovc "+m_video;
        if (!m_audio.isEmpty())
            m_audio="-oac " +m_audio;
        _cmd=" "+m_video+" "+m_audio+" "+m_filters;
    }
    delete m_cmdGen;
    return res;
}

void k9MencoderCmdGen::parseCmd(const TQString &_cmd){
    TQString cmd(_cmd);
    cmd=cmd.replace("\n"," ").simplifyWhiteSpace();
    TQStringList cmdList=TQStringList::split(" ",cmd);
    for (TQStringList::iterator it=cmdList.begin();it!=cmdList.end();++it) {
        if (*it=="-ovc") {
            ++it;
            selectCodec("VIDEO",*it);            
        } else if (*it=="-oac") {
            ++it;
            selectCodec("AUDIO",*it);            
        } else { 
            if (*it=="-vf") 
                selectCodec("FILTERS","vf");
            else if (*it=="-af") 
                selectCodec("FILTERS","af");
            TQDomNodeList lRoot=m_doc.documentElement().childNodes();
            bool bFound=false;
            TQString sCodec=*it;
            for (int i=0;i<lRoot.count();i++) {
                TQDomElement eRoot=lRoot.item(i).toElement();
                TQDomNodeList lCodec=eRoot.childNodes();
                for (int j=0;j<lCodec.count();j++) {
                    TQDomElement eCodec=lCodec.item(j).toElement();
                    TQString sOptName="";
                    if (eCodec.attributeNode("options").isNull())
                        sOptName="-"+eCodec.nodeName();
                    else
                        sOptName="-"+eCodec.attributeNode("options").value();
                    if ( sOptName ==sCodec) {
                        if (!bFound)
                            ++it;
                        parseCodecOptions(eRoot.nodeName(),eCodec.nodeName(),*it);
                        bFound=true;        
                    }
                }

            }
        }
    }
}

void k9MencoderCmdGen::parseCodecOptions(const TQString &_root,const TQString &_codec,const TQString & _options) {

    TQString m_sepOpt=":";
    TQString m_sepValues=",";

    TQDomElement eRoot=m_doc.documentElement().elementsByTagName(_root).item(0).toElement();
    TQDomElement eCodec=eRoot.elementsByTagName(_codec).item(0).toElement();

    if (! eCodec.attributeNode("separator").isNull())
        m_sepOpt=eCodec.attributeNode("separator").value();

    TQStringList slOptions=TQStringList::split(m_sepOpt,_options);
    TQDomNodeList lOpt=eCodec.elementsByTagName("opt");


    for (int i=0;i <lOpt.count();i++) {
        TQDomElement eOpt=lOpt.item(i).toElement();
        TQString sName=eOpt.attributeNode("name").value();
        if (! eOpt.attributeNode("separator").isNull())
            m_sepValues=eOpt.attributeNode("separator").value();

        //extract the option (optname=value)
        TQStringList sl=slOptions.grep(sName,false);
        TQString sOpt="";
        for (TQStringList::iterator it=slOptions.begin();it !=slOptions.end();++it) 
            if (*it==sName || (*it).startsWith(sName+"="))
                sOpt=*it;

        if (sOpt!="") {
            //TQString sOpt=*(sl.at(0));
            TQString value;
            if (eOpt.attributeNode("type").isNull()) {
                //it's a list of values
                TQString sValues=sOpt.replace("="+m_sepValues,"= "+m_sepValues).replace(m_sepValues+m_sepValues,m_sepValues+" "+m_sepValues).replace(m_sepValues+m_sepValues,m_sepValues+" "+m_sepValues).section("=",1);
                TQStringList slValues=TQStringList::split(m_sepValues,sValues);
                //loop on values nodes
                TQDomNodeList lSOpt=eOpt.elementsByTagName("subopt");
                for (int j=0;j<lSOpt.count();j++) {
                    TQDomElement eSOpt=lSOpt.item(j).toElement();
                    //if (eSOpt.attributeNode("type").value()=="int") {
                    if (eSOpt.attributeNode("prefix").isNull()) {
                        if (j< slValues.count() && *(slValues.at(j)) !=" " ) {
                            TQString sVal=*(slValues.at(j));
                            if (eSOpt.attributeNode("type").value()=="bool")
                                sVal="true";
                            eSOpt.setAttribute("default",sVal);
                            eSOpt.setAttribute("selected","true");
                        }
                    } else {
                        TQString sPrefix=eSOpt.attributeNode("prefix").value();
                        for (int k=0;k<slValues.count();k++) {
                            TQString s=*(slValues.at(k));
                            if (s.startsWith(sPrefix)) {
                                eSOpt.setAttribute("default",s.replace(sPrefix,""));
                                eSOpt.setAttribute("selected","true");
                            }
                        }
                    }
                }
            } else if (eOpt.attributeNode("type").value()=="bool" )
                value="true";
            else
                value=sOpt.section("=",1,1);
            eOpt.setAttribute("default",value);
            eOpt.setAttribute("selected","true");
        }
    }
}

void k9MencoderCmdGen::selectCodec(const TQString &_root,const TQString &_codec) {
    TQDomElement root=m_doc.documentElement().elementsByTagName(_root).item(0).toElement();
    TQDomElement codec=root.elementsByTagName(_codec).item(0).toElement();
    if (!codec.isNull())
        codec.setAttribute("selected","true");
}


#include "k9mencodercmdgen.moc"

