// #### Do not edit: this file is autogenerated !!!

#include "devices/list/device_list.h"
#include "pickit1.h"
#include "pickit1_data.h"
#include "pickit1_prog.h"

namespace Pickit1
{
struct CData {
  const char *name;
  uint family;
  uint support;
  Data data;
};

const CData PIC10F200_DATA = {  "10F200", 0, 2, { 'O', false } };
const CData PIC10F202_DATA = {  "10F202", 0, 2, { 'O', false } };
const CData PIC10F204_DATA = {  "10F204", 0, 2, { 'O', false } };
const CData PIC10F206_DATA = {  "10F206", 0, 2, { 'O', false } };
const CData PIC10F220_DATA = {  "10F220", 0, 1, { 'O', false } };
const CData PIC10F222_DATA = {  "10F222", 0, 1, { 'O', false } };
const CData PIC12F508_DATA = {  "12F508", 0, 2, { 'O', false } };
const CData PIC12F509_DATA = {  "12F509", 0, 2, { 'O', false } };
const CData PIC12F510_DATA = {  "12F510", 0, 2, { 'O', false } };
const CData PIC12F629_DATA = {  "12F629", 1, 2, { 'P', true } };
const CData PIC12F635_DATA = {  "12F635", 1, 2, { 'P', false } };
const CData PIC12F675_DATA = {  "12F675", 1, 2, { 'P', true } };
const CData PIC12F683_DATA = {  "12F683", 1, 2, { 'P', false } };
const CData PIC16F505_DATA = {  "16F505", 0, 1, { 'O', false } };
const CData PIC16F506_DATA = {  "16F506", 0, 1, { 'O', false } };
const CData PIC16F54_DATA = {  "16F54", 0, 1, { 'O', false } };
const CData PIC16F57_DATA = {  "16F57", 0, 1, { 'O', false } };
const CData PIC16F59_DATA = {  "16F59", 0, 1, { 'O', false } };
const CData PIC16F627A_DATA = {  "16F627A", 1, 1, { 'P', false } };
const CData PIC16F628A_DATA = {  "16F628A", 1, 1, { 'P', false } };
const CData PIC16F630_DATA = {  "16F630", 1, 2, { 'P', true } };
const CData PIC16F636_DATA = {  "16F636", 1, 2, { 'P', false } };
const CData PIC16F639_DATA = {  "16F639", 1, 2, { 'P', false } };
const CData PIC16F648A_DATA = {  "16F648A", 1, 1, { 'P', false } };
const CData PIC16F676_DATA = {  "16F676", 1, 2, { 'P', true } };
const CData PIC16F684_DATA = {  "16F684", 1, 2, { 'P', false } };
const CData PIC16F685_DATA = {  "16F685", 1, 1, { 'P', false } };
const CData PIC16F687_DATA = {  "16F687", 1, 1, { 'P', false } };
const CData PIC16F688_DATA = {  "16F688", 1, 2, { 'P', false } };
const CData PIC16F689_DATA = {  "16F689", 1, 1, { 'P', false } };
const CData PIC16F690_DATA = {  "16F690", 1, 1, { 'P', false } };
const CData PIC16F716_DATA = {  "16F716", 2, 1, { 'O', false } };
const CData PIC16F785_DATA = {  "16F785", 1, 1, { 'P', false } };
const CData PIC16F877A_DATA = {  "16F877A", 1, 1, { 'O', false } };
const CData PIC16F913_DATA = {  "16F913", 1, 1, { 'O', false } };
const CData PIC16F914_DATA = {  "16F914", 1, 1, { 'O', false } };
const CData PIC16F916_DATA = {  "16F916", 1, 1, { 'O', false } };
const CData PIC16F917_DATA = {  "16F917", 1, 1, { 'O', false } };
const CData PIC16F946_DATA = {  "16F946", 1, 1, { 'O', false } };

const CData *DATA_LIST[] = {
&PIC10F200_DATA,&PIC10F202_DATA,&PIC10F204_DATA,&PIC10F206_DATA,&PIC10F220_DATA,&PIC10F222_DATA,&PIC12F508_DATA,&PIC12F509_DATA,&PIC12F510_DATA,&PIC12F629_DATA,
&PIC12F635_DATA,&PIC12F675_DATA,&PIC12F683_DATA,&PIC16F505_DATA,&PIC16F506_DATA,&PIC16F54_DATA,&PIC16F57_DATA,&PIC16F59_DATA,&PIC16F627A_DATA,&PIC16F628A_DATA,
&PIC16F630_DATA,&PIC16F636_DATA,&PIC16F639_DATA,&PIC16F648A_DATA,&PIC16F676_DATA,&PIC16F684_DATA,&PIC16F685_DATA,&PIC16F687_DATA,&PIC16F688_DATA,&PIC16F689_DATA,
&PIC16F690_DATA,&PIC16F716_DATA,&PIC16F785_DATA,&PIC16F877A_DATA,&PIC16F913_DATA,&PIC16F914_DATA,&PIC16F916_DATA,&PIC16F917_DATA,&PIC16F946_DATA,0 
};

const CData *cdata(const TQString &device)
{
  for(uint i=0; DATA_LIST[i]; i++)
    if ( device==DATA_LIST[i]->name ) return DATA_LIST[i];
  return 0;
}
bool isSupported(const TQString &device)
{
  return cdata(device);
}
uint family(const TQString &device)
{
  return cdata(device)->family;
}
::Group::Support support(const TQString &device)
{
  return ::Group::Support::Type(cdata(device)->support);
}
const Data &data(const TQString &device)
{
  return cdata(device)->data;
}

void Group::initSupported()
{
  for (uint i=0; DATA_LIST[i]; i++) {
    const Device::Data *data = Device::lister().data(DATA_LIST[i]->name);
    addDevice(data->name(), data, ::Group::Support::Type(DATA_LIST[i]->support));
  }
}

::Programmer::DeviceSpecific *Group::createDeviceSpecific(Programmer::Base &base) const
{
  uint i = family(static_cast< ::Pickit1::Base &>(base).device()->name());
  switch(i) {
    case 0: return new Baseline(base);
    case 1: return new P16F(base);
    case 2: return new P16F716(base);
  }
  Q_ASSERT(false);
  return 0;
}

}
