/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import nu.validator.xml.ContentHandlerFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ForbiddenCharacterFilter
extends ContentHandlerFilter {
    private static final char[] REPLACEMENT_CHARACTER = new char[]{'\ufffd'};

    public ForbiddenCharacterFilter(ContentHandler contentHandler) {
        super(contentHandler, null);
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if ((c >= ' ' && c <= '\ufffd' || c == '\t' || c == '\n' || c == '\r') && c != '\ufeff' && (c < '\u007f' || c > '\u009f') && (c < '\ufdd0' || c > '\ufddf')) continue;
            if (start < i) {
                super.characters(chars, start, i - start);
            }
            super.characters(REPLACEMENT_CHARACTER, 0, 1);
            start = i + 1;
        }
        if (start < end) {
            super.characters(chars, start, end - start);
        }
    }
}

