/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.Source;

public class ListenerHolder
extends BaseHolder<EventListener> {
    private EventListener _listener;
    private boolean _initialized = false;

    public ListenerHolder() {
        this(Source.EMBEDDED);
    }

    public ListenerHolder(Source source) {
        super(source);
    }

    public ListenerHolder(Class<? extends EventListener> listenerClass) {
        super(Source.EMBEDDED);
        this.setHeldClass(listenerClass);
    }

    public EventListener getListener() {
        return this._listener;
    }

    public void setListener(EventListener listener) {
        this._listener = listener;
        this._extInstance = true;
        this.setHeldClass(this._listener.getClass());
    }

    public void initialize(ServletContext context) throws Exception {
        if (!this._initialized) {
            this.initialize();
            if (this._listener == null) {
                try {
                    this._listener = context instanceof ServletContextHandler.Context ? ((ServletContextHandler.Context)context).createListener(this.getHeldClass()) : (EventListener)this.getHeldClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ServletException se) {
                    Throwable cause = se.getRootCause();
                    if (cause instanceof InstantiationException) {
                        throw (InstantiationException)cause;
                    }
                    if (cause instanceof IllegalAccessException) {
                        throw (IllegalAccessException)cause;
                    }
                    throw se;
                }
            }
            this._initialized = true;
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (!EventListener.class.isAssignableFrom(this._class)) {
            String msg = this._class + " is not a java.util.EventListener";
            super.stop();
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (!this._extInstance) {
            this._listener = null;
        }
        this._initialized = false;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getClassName();
    }
}

