/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;

public class DecimalFormatManager
implements Serializable {
    private DecimalSymbols defaultDFS;
    private HashMap formatTable = new HashMap(10);
    private boolean usingOriginalDefault = true;
    public static final StructuredQName DEFAULT_NAME = new StructuredQName("saxon", "http://saxon.sf.net/", "default-decimal-format");

    public DecimalFormatManager() {
        DecimalSymbols d = new DecimalSymbols();
        DecimalFormatManager.setDefaults(d);
        this.defaultDFS = d;
    }

    public static void setDefaults(DecimalSymbols d) {
        d.decimalSeparator = 46;
        d.groupingSeparator = 44;
        d.infinity = "Infinity";
        d.minusSign = 45;
        d.NaN = "NaN";
        d.percent = 37;
        d.permill = 8240;
        d.zeroDigit = 48;
        d.digit = 35;
        d.patternSeparator = 59;
    }

    public void setDefaultDecimalFormat(DecimalSymbols dfs, int precedence) throws XPathException {
        if (!this.usingOriginalDefault && !dfs.equals(this.defaultDFS)) {
            XPathException err = new XPathException("There are two conflicting definitions of the default decimal format");
            err.setErrorCode("XTSE1290");
            err.setIsStaticError(true);
            throw err;
        }
        this.defaultDFS = dfs;
        this.usingOriginalDefault = false;
        this.setNamedDecimalFormat(DEFAULT_NAME, dfs, precedence);
    }

    public void fixupDefaultDefault() throws XPathException {
        if (this.usingOriginalDefault) {
            this.setNamedDecimalFormat(DEFAULT_NAME, this.defaultDFS, -1000);
        }
    }

    public DecimalSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public void setNamedDecimalFormat(StructuredQName qName, DecimalSymbols dfs, int precedence) throws XPathException {
        Object o = this.formatTable.get(qName);
        if (o != null) {
            if (o instanceof List) {
                Iterator iter = ((List)o).iterator();
                while (iter.hasNext()) {
                    FormatNumber call = (FormatNumber)iter.next();
                    call.fixup(dfs);
                }
            } else {
                DecimalFormatInfo info = (DecimalFormatInfo)o;
                DecimalSymbols old = info.dfs;
                int oldPrecedence = info.precedence;
                if (precedence < oldPrecedence) {
                    return;
                }
                if (precedence == oldPrecedence && !dfs.equals(old)) {
                    XPathException err = new XPathException("There are two conflicting definitions of the named decimal-format");
                    err.setErrorCode("XTSE1290");
                    err.setIsStaticError(true);
                    throw err;
                }
            }
        }
        DecimalFormatInfo dfi = new DecimalFormatInfo();
        dfi.dfs = dfs;
        dfi.precedence = precedence;
        this.formatTable.put(qName, dfi);
    }

    public void registerUsage(StructuredQName qName, FormatNumber call) {
        Object o = this.formatTable.get(qName);
        if (o == null) {
            ArrayList<FormatNumber> list = new ArrayList<FormatNumber>(10);
            list.add(call);
            this.formatTable.put(qName, list);
        } else if (o instanceof List) {
            List list = (List)o;
            list.add(call);
        } else {
            DecimalFormatInfo dfi = (DecimalFormatInfo)o;
            call.fixup(dfi.dfs);
        }
    }

    public DecimalSymbols getNamedDecimalFormat(StructuredQName qName) {
        DecimalFormatInfo dfi = (DecimalFormatInfo)this.formatTable.get(qName);
        if (dfi == null) {
            return null;
        }
        return dfi.dfs;
    }

    private static class DecimalFormatInfo
    implements Serializable {
        public DecimalSymbols dfs;
        public int precedence;

        private DecimalFormatInfo() {
        }
    }
}

