use std::error::Error;
use std::fs;
use std::path::Path;

pub fn load_subscriptions<P: AsRef<Path>>(path: P) -> Result<Vec<String>, Box<dyn Error>> {
    let content = fs::read_to_string(path)?;
    let subs = content
        .lines()
        .map(|line| line.trim().to_string())
        .filter(|s| !s.is_empty())
        .collect();
    Ok(subs)
}
