use std::error::Error;
use std::process::Command;

// Here we use pass so works with gopass
// it expects servername/user to get password from
// password manager
pub fn get_password(username: &str, server: &str) -> Result<String, Box<dyn Error>> {
    let key = format!("{}/{}", server, username);
    let output = Command::new("pass")
        .arg("show")
        .arg("-o")
        .arg(&key)
        .output()?;
    if output.status.success() {
        Ok(String::from_utf8(output.stdout)?.trim().to_string())
    } else {
        Err(format!("Failed to retrieve password for key '{}'", key).into())
    }
}
