use serde::Deserialize;
use std::error::Error;
use std::fs;
use std::path::Path;

#[derive(Deserialize, Debug)]
pub struct AppConfig {
    #[serde(rename = "usenet")]
    pub usenet: UsenetConfig,
    pub headers: HeaderConfig,
    pub display: DisplayConfig,
}

#[derive(Deserialize, Debug)]
pub struct UsenetConfig {
    #[serde(rename = "server")]
    pub server: UsenetServerConfig,
}

#[derive(Deserialize, Debug)]
pub struct UsenetServerConfig {
    pub username: String,
    pub password: String,
    pub server: String,
}

#[derive(Deserialize, Debug)]
pub struct HeaderConfig {
    #[serde(rename = "from_header")]
    pub from: String,
    #[serde(rename = "email_header")]
    pub email: String,
}

#[derive(Debug, Deserialize)]
pub struct DisplayConfig {
    pub threaded_view: bool,
}

impl AppConfig {
    pub fn load<P: AsRef<Path>>(path: P) -> Result<Self, Box<dyn Error>> {
        let content = fs::read_to_string(path)?;
        let cfg = toml::from_str(&content)?;
        Ok(cfg)
    }
}
