/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as f,html as r}from"lit";import{property as u,customElement as g}from"lit/decorators.js";import{lll as s}from"@typo3/core/lit-helper.js";import"@typo3/backend/element/icon-element.js";import h from"@typo3/backend/modal.js";var d=function(p,t,e,a){var l=arguments.length,n=l<3?t:a===null?a=Object.getOwnPropertyDescriptor(t,e):a,i;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")n=Reflect.decorate(p,t,e,a);else for(var o=p.length-1;o>=0;o--)(i=p[o])&&(n=(l<3?i(n):l>3?i(t,e,n):i(t,e))||n);return l>3&&n&&Object.defineProperty(t,e,n),n};let c=class extends f{constructor(){super(...arguments),this.type="textarea",this.selectorData="",this.delimiter="|",this.enclosure="",this.appendRows=1,this.table=[]}get firstRow(){return this.table[0]||[]}connectedCallback(){super.connectedCallback(),this.selectorData=this.getAttribute("selector"),this.delimiter=this.getAttribute("delimiter"),this.enclosure=this.getAttribute("enclosure")||"",this.readTableFromTextarea()}createRenderRoot(){return this}render(){return this.renderTemplate()}provideMinimalTable(){(this.table.length===0||this.firstRow.length===0)&&(this.table=[[""]])}readTableFromTextarea(){const t=document.querySelector(this.selectorData),e=[];t.value.split(`
`).forEach(a=>{if(a!==""){this.enclosure&&(a=a.replace(new RegExp(this.enclosure,"g"),""));const l=a.split(this.delimiter);e.push(l)}}),this.table=e}writeTableSyntaxToTextarea(){const t=document.querySelector(this.selectorData);let e="";this.table.forEach(a=>{const l=a.length;e+=a.reduce((n,i,o)=>{const b=l-1===o?"":this.delimiter;return i=i.replace(/\r?\n/g,"<br>"),n+this.enclosure+i+this.enclosure+b},"")+`
`}),t.value=e,t.dispatchEvent(new CustomEvent("change",{bubbles:!0}))}modifyTable(t,e,a){const l=t.target;this.table[e][a]=l.value,this.writeTableSyntaxToTextarea(),this.requestUpdate()}toggleType(){this.type=this.type==="input"?"textarea":"input"}moveColumn(t,e){this.table=this.table.map(a=>{const l=a.splice(t,1);return a.splice(e,0,...l),a}),this.writeTableSyntaxToTextarea(),this.requestUpdate()}appendColumn(t,e){this.table=this.table.map(a=>(a.splice(e+1,0,""),a)),this.writeTableSyntaxToTextarea(),this.requestUpdate()}removeColumn(t,e){this.table=this.table.map(a=>(a.splice(e,1),a)),this.writeTableSyntaxToTextarea(),this.requestUpdate()}moveRow(t,e,a){const l=this.table.splice(e,1);this.table.splice(a,0,...l),this.writeTableSyntaxToTextarea(),this.requestUpdate()}appendRow(t,e){const a=this.firstRow.concat().fill(""),l=new Array(this.appendRows).fill(a);this.table.splice(e+1,0,...l),this.writeTableSyntaxToTextarea(),this.requestUpdate()}removeRow(t,e){this.table.splice(e,1),this.writeTableSyntaxToTextarea(),this.requestUpdate()}renderTemplate(){this.provideMinimalTable();const t=Object.keys(this.firstRow).map(l=>parseInt(l,10)),e=t[t.length-1],a=this.table.length-1;return r`<div class="table-fit table-fit-inline-block"><table class="table table-center"><thead><th>${this.renderTypeButton()}</th>${t.map(l=>r`<th>${this.renderColButtons(l,e)}</th>`)}</thead><tbody>${this.table.map((l,n)=>r`<tr><td>${this.renderRowButtons(n,a)}</td>${l.map((i,o)=>r`<td>${this.renderDataElement(i,n,o)}</td>`)}</tr>`)}</tbody></table></div>`}renderDataElement(t,e,a){const l=n=>this.modifyTable(n,e,a);switch(this.type){case"input":return r`<input class=form-control type=text data-row=${e} data-col=${a} @change=${l} .value=${t.replace(/\n/g,"<br>")}>`;case"textarea":default:return r`<textarea class=form-control rows=6 data-row=${e} data-col=${a} @change=${l} .value=${t.replace(/<br[ ]*\/?>/g,`
`)}></textarea>`}}renderTypeButton(){return r`<span class=btn-group> <button class="btn btn-default" type=button title=${s("table_smallFields")} @click=${()=>this.toggleType()}><typo3-backend-icon identifier=${this.type==="input"?"actions-chevron-expand":"actions-chevron-contract"} size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${s("table_setCount")} @click=${t=>this.showTableConfigurationModal(t)}><typo3-backend-icon identifier=actions-plus size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${s("table_showCode")} @click=${()=>this.showTableSyntax()}><typo3-backend-icon identifier=actions-code size=small></typo3-backend-icon></button> </span>`}renderColButtons(t,e){const a={title:t===0?s("table_end"):s("table_left"),class:t===0?"bar-right":"left",target:t===0?e:t-1},l={title:t===e?s("table_start"):s("table_right"),class:t===e?"bar-left":"right",target:t===e?0:t+1};return r`<span class=btn-group> <button class="btn btn-default" type=button title=${a.title} @click=${()=>this.moveColumn(t,a.target)}><typo3-backend-icon identifier=actions-chevron-${a.class} size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${l.title} @click=${()=>this.moveColumn(t,l.target)}><typo3-backend-icon identifier=actions-chevron-${l.class} size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${s("table_removeColumn")} @click=${n=>this.removeColumn(n,t)}><typo3-backend-icon identifier=actions-delete size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${s("table_addColumn")} @click=${n=>this.appendColumn(n,t)}><typo3-backend-icon identifier=actions-plus size=small></typo3-backend-icon></button> </span>`}renderRowButtons(t,e){const a={title:t===0?s("table_bottom"):s("table_up"),class:t===0?"bar-down":"up",target:t===0?e:t-1},l={title:t===e?s("table_top"):s("table_down"),class:t===e?"bar-up":"down",target:t===e?0:t+1};return r`<span class=btn-group${this.type==="input"?"":"-vertical"}> <button class="btn btn-default" type=button title=${a.title} @click=${n=>this.moveRow(n,t,a.target)}><typo3-backend-icon identifier=actions-chevron-${a.class} size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${l.title} @click=${n=>this.moveRow(n,t,l.target)}><typo3-backend-icon identifier=actions-chevron-${l.class} size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${s("table_removeRow")} @click=${n=>this.removeRow(n,t)}><typo3-backend-icon identifier=actions-delete size=small></typo3-backend-icon></button> <button class="btn btn-default" type=button title=${s("table_addRow")} @click=${n=>this.appendRow(n,t)}><typo3-backend-icon identifier=actions-plus size=small></typo3-backend-icon></button> </span>`}showTableConfigurationModal(t){const e=this.firstRow.length,a=this.table.length,l=a||1,n=e||1,i=h.advanced({content:r`<div class=form-group><label for=t3js-expand-rows class=form-label>${s("table_rowCount")}</label> <input id=t3js-expand-rows class=form-control type=number min=1 required value=${l}></div><div class=form-group><label for=t3js-expand-cols class=form-label>${s("table_colCount")}</label> <input id=t3js-expand-cols class=form-control type=number min=1 required value=${n}></div>`,title:s("table_setCountHeadline"),size:h.sizes.small,buttons:[{text:s("labels.cancel")||"Cancel",btnClass:"btn-default",name:"cancel",trigger:()=>i.hideModal()},{text:s("table_buttonUpdate")||"Update",active:!0,btnClass:"btn-primary",name:"apply",trigger:()=>{const o=i.querySelector("#t3js-expand-rows"),b=i.querySelector("#t3js-expand-cols");if(!(o===null||b===null))if(o.checkValidity()&&b.checkValidity()){const m=Number(o.value)-a,y=Number(b.value)-e;this.setColAndRowCount(t,y,m),i.hideModal()}else o.reportValidity(),b.reportValidity()}}]})}showTableSyntax(){const t=document.querySelector(this.selectorData),e=h.advanced({content:r`<div class=form-group><label for=table-wizard-textarea-raw class=form-label>${s("table_showCodeLabel")}</label> <textarea id=table-wizard-textarea-raw rows=8 class=form-control>${t.value}</textarea></div>`,title:s("table_showCodeHeadline"),size:h.sizes.small,buttons:[{text:s("labels.cancel")||"Cancel",btnClass:"btn-default",name:"cancel",trigger:()=>e.hideModal()},{text:s("table_buttonUpdate")||"Update",active:!0,btnClass:"btn-primary",name:"apply",trigger:()=>{t.value=e.querySelector("textarea").value,t.dispatchEvent(new CustomEvent("change",{bubbles:!0})),this.readTableFromTextarea(),this.requestUpdate(),e.hideModal()}}]})}setColAndRowCount(t,e,a){const l=this.table.length;if(a>0)for(let n=0;n<a;n++)this.appendRow(t,l);else for(let n=0;n<Math.abs(a);n++)this.removeRow(t,this.table.length-1);if(e>0)for(let n=0;n<e;n++)this.appendColumn(t,e);else for(let n=0;n<Math.abs(e);n++)this.removeColumn(t,this.firstRow.length-1)}};d([u({type:String})],c.prototype,"type",void 0),d([u({type:String})],c.prototype,"selectorData",void 0),d([u({type:String})],c.prototype,"delimiter",void 0),d([u({type:String})],c.prototype,"enclosure",void 0),d([u({type:Number,attribute:"append-rows"})],c.prototype,"appendRows",void 0),c=d([g("typo3-formengine-table-wizard")],c);export{c as TableWizardElement};
