/*--------------------------------------------------------------------------
 *  Copyright 2011 Taro L. Saito
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *--------------------------------------------------------------------------*/
//--------------------------------------
// XerialJ
//
// Maven.java
// Since: 2011/02/04 11:18:41
//
// $URL$
// $Author$
//--------------------------------------
package org.xerial.silk.weaver.cui;

import org.apache.maven.cli.MavenCli;
import org.xerial.util.opt.Command;

public class Maven implements Command
{

    @Override
    public String name() {
        return "maven";
    }

    @Override
    public String getOneLineDescription() {
        return "Run Maven";
    }

    @Override
    public Object getOptionHolder() {
        return null;
    }

    @Override
    public void execute(String[] args) throws Exception {
        MavenCli.doMain(args, null);
    }
}
