#!/usr/bin/env ruby
#
# Copyright (c) 2004-2005 Sean Chittenden <sean@chittenden.org>
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
# $RubyForge$

require 'mkmf'

if defined?(CFLAGS)
  if CFLAGS.index(CONFIG['CCDLFLAGS'])
    $CFLAGS = CFLAGS
  else
    $CFLAGS = CFLAGS + ' ' + CONFIG['CCDLFLAGS']
  end
else
  $CFLAGS = CONFIG['CFLAGS']
end
# $CFLAGS = $CFLAGS + ' -std=c99 -g -Wall -Wunused -Wshadow -Wpointer-arith -Wbad-function-cast -Wcast-qual -Wcast-align -Wwrite-strings -Wsign-compare -Waggregate-return -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations -Wmissing-noreturn -Wformat -Wpacked -Wdeprecated-declarations -Wredundant-decls -Wnested-externs -Winline -Wdisabled-optimization -pipe -pedantic'
$CFLAGS = $CFLAGS + ' -std=c99 -g -pipe'

$LDFLAGS = CONFIG['LDFLAGS']
$LIBPATH.push(Config::CONFIG['libdir'])

def crash(str)
  printf(" extconf failure: %s\n", str)
  exit 1
end

dir_config('memcache')

unless have_library('memcache', 'mc_new')
 crash(<<EOL)
need memcache(3).

        Install the library or try one of the following options to #{$0}:

        --with-memcache-dir=/path/to/libmemcache
        --with-memcache-lib=/path/to/libmemcache/lib
        --with-memcache-include=/path/to/libmemcache/include
EOL
end

$cleanfiles.push('mkmf.log')
$distcleanfiles.push('Makefile')
create_header()
create_makefile('memcache')
