require "eet"
require "test/unit"

class StreamTest < Test::Unit::TestCase
	def setup
		stream = Eet::Stream.new
		stream << Eet::Chunk.new("tag", "foo")
		stream << Eet::Chunk.new("tag2", "bar")
		stream << Eet::Chunk.new("tag23", "baz")

		@data = stream.to_s
		assert_not_nil(@data)
	end

	def test_serialize
		assert_equal("CHnK\007\0\0\0tag\0foo" +
		             "CHnK\010\0\0\0tag2\0bar" +
		             "CHnK\011\0\0\0tag23\0baz", @data)
	end

	def test_deserialize
		stream = nil

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(@data)
		end

		assert_equal(3, stream.length)

		values = {"tag" => "foo", "tag2" => "bar", "tag23" => "baz"}
		values.each do |k, v|
			found = stream.find { |c| c.tag == k }
			assert_not_nil(found, "chunk not found - #{k}")
			assert_equal(found.data, v)
			stream.delete(found)
		end

		assert_equal([], stream)
	end
end
